
package actionjava.anim.events;

public class TweenEvent extends Event
{
	// Event Name
	public static final String EVENT_NAME = "net.atremmedia.gwt.actionjava.anim.events.TweenEvent";

	// Event types
	public enum TweenEventType implements EventType
	{
		DUMMY
		{
			@Override
			public String getType()
			{
				return TweenEvent.DUMMY;
			}
		},
		START
		{
			@Override
			public String getType()
			{
				return TweenEvent.START;
			}
		},
		UPDATE
		{
			@Override
			public String getType()
			{
				return TweenEvent.UPDATE;
			}
		},
		COMPLETE
		{
			@Override
			public String getType()
			{
				return TweenEvent.COMPLETE;
			}
		},
		REVERSE_COMPLETE
		{
			@Override
			public String getType()
			{
				return TweenEvent.REVERSE_COMPLETE;
			}
		};

		@Override
		public abstract String getType();
	}

	// Event types
	public static final String DUMMY = "dummy";
	public static final String START = "tweenStart";
	public static final String UPDATE = "tweenUpdate";
	public static final String COMPLETE = "tweenComplete";
	public static final String REVERSE_COMPLETE = "tweenReverseComplete";

	private TweenEventParams data;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructors
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public TweenEvent(TweenEventType type, TweenEventParams data)
	{
		super(TweenEvent.EVENT_NAME, type, false, false);
		initialize(data);
	}

	public TweenEvent(TweenEventType type, boolean bubbles, boolean cancelable, TweenEventParams data)
	{
		super(TweenEvent.EVENT_NAME, type, bubbles, cancelable);
		initialize(data);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	private void initialize(TweenEventParams data)
	{
		this.data = data;
	}

	public TweenEventParams getParams()
	{
		return data;
	}
}
