
package actionjava.anim.events;

import actionjava.anim.events.Event.EventType;
import actionjava.anim.events.TweenEvent.TweenEventType;

public abstract class TweenEventHandler extends EventHandler
{
	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructors
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public TweenEventHandler(EventType type)
	{
		super(type);
	}

	public TweenEventHandler(EventType type, boolean once)
	{
		super(type, once);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Protected Methods
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	protected final void delegateEvent(Event event)
	{
		try {
			TweenEvent tEvent = (TweenEvent) event;
			TweenEventParams params = (tEvent.getParams() != null) ? (TweenEventParams) tEvent.getParams() : new TweenEventParams();

			if(tEvent.getEventType().equals(TweenEventType.START.getType())) {
				tweenStart(tEvent, params);
			} else if(tEvent.getEventType().equals(TweenEventType.UPDATE.getType())) {
				tweenUpdate(tEvent, params);
			} else if(tEvent.getEventType().equals(TweenEventType.COMPLETE.getType())) {
				tweenComplete(tEvent, params);
			} else if(tEvent.getEventType().equals(TweenEventType.REVERSE_COMPLETE.getType())) {
				tweenReverseComplete(tEvent, params);
			}

		} catch (ClassCastException e) {
			return;
		}
	}

	protected abstract void tweenStart(TweenEvent event, TweenEventParams params);

	protected abstract void tweenUpdate(TweenEvent event, TweenEventParams params);

	protected abstract void tweenComplete(TweenEvent event, TweenEventParams params);

	protected abstract void tweenReverseComplete(TweenEvent event, TweenEventParams params);

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Public Methods
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public String getEventName()
	{
		return TweenEvent.EVENT_NAME;
	}
}
