
package actionjava.anim.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TweenEventParams
{
	private final Map<String, Param> params = new HashMap<String, Param>();

	public TweenEventParams()
	{
		super();
	}

	public TweenEventParams(List<Param> params)
	{
		super();
		if(params != null) {
			initialize(params.toArray(new Param[params.size()]));
		}
	}

	public TweenEventParams(Param[] params)
	{
		super();
		if(params != null) {
			initialize(params);
		}
	}

	private void initialize(Param[] params)
	{
		addAll(params);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Add Params
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public TweenEventParams add(String key, Object value)
	{
		add(new Param(key, value));
		return this;
	}

	public TweenEventParams add(Param param)
	{
		params.put(param.getKey(), param);
		return this;
	}

	public TweenEventParams addAll(Param[] params)
	{
		for(int i = 0;i < params.length;i++) {
			Param param = params[i];
			add(param);
		}

		return this;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Get params several ways
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public String[] getParamNames()
	{
		return getParamNamesList().toArray(new String[params.size()]);
	}

	public List<String> getParamNamesList()
	{
		return new ArrayList<String>(params.keySet());
	}

	public Object[] getParamValues()
	{
		return getParamValuesList().toArray(new Object[params.size()]);
	}

	public List<Object> getParamValuesList()
	{
		return new ArrayList<Object>(params.values());
	}

	public boolean isEmpty()
	{
		return params.isEmpty();
	}

	public boolean containsParam(String name)
	{
		return params.containsKey(name);
	}

	public boolean containsValue(Object value)
	{
		return params.containsValue(value);
	}

	public int getNumParams()
	{
		return params.size();
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Get Casted Property Values
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public int getIntegerValue(String name)
	{
		try {
			return (Integer) params.get(name).getValue();
		} catch (ClassCastException e) {
			return 0;
		}
	}

	public float getFloatValue(String name)
	{
		try {
			return (Float) params.get(name).getValue();
		} catch (ClassCastException e) {
			return 0F;
		}
	}

	public double getDoubleValue(String name)
	{
		try {
			return (Double) params.get(name).getValue();
		} catch (ClassCastException e) {
			return 0;
		}
	}

	public boolean getBooleanValue(String name)
	{
		return ((Boolean) params.get(name).getValue());
	}

	public String getStringValue(String name)
	{
		try {
			return (String) params.get(name).getValue();
		} catch (ClassCastException e) {
			return null;
		}
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Parameter
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public class Param
	{
		private String key;
		private Object value;

		public Param(String key, Object value)
		{
			super();
			initialze(key, value);
		}

		private void initialze(String key, Object value)
		{
			this.key = key;
			this.value = value;
		}

		public String getKey()
		{
			return key;
		}

		public Object getValue()
		{
			return value;
		}

		//
		//
		// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		// - - Get Casted Property Values
		// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		//
		//

		public int getIntegerValue(String name)
		{
			try {
				return (Integer) value;
			} catch (ClassCastException e) {
				return 0;
			}
		}

		public float getFloatValue(String name)
		{
			try {
				return (Float) value;
			} catch (ClassCastException e) {
				return 0F;
			}
		}

		public double getDoubleValue(String name)
		{
			try {
				return (Double) value;
			} catch (ClassCastException e) {
				return 0;
			}
		}

		public boolean getBooleanValue(String name)
		{
			return ((Boolean) value);
		}

		public String getStringValue(String name)
		{
			try {
				return (String) value;
			} catch (ClassCastException e) {
				return null;
			}
		}
	}
}
