
package actionjava.anim;

import actionjava.anim.config.Manifest;

public final class Anim extends AnimModule
{
	private Anim()
	{
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Basic Operations
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public static ITween tween(Manifest mf)
	{
		return getInstance().createTween(mf);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Singleton pattern & Module Injection
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	private static Anim getInstance()
	{
		return SingletonAnimHolder.INSTANCE;
	}

	private static class SingletonAnimHolder
	{
		private static Anim INSTANCE = null;

		static {
			try {
				INSTANCE = new Anim();
			} catch (Exception e) {}
		}
	}
}
