
package actionjava.anim.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import actionjava.anim.core.TweenProp;
import actionjava.anim.core.props.IPropBridge;
import actionjava.anim.core.props.PropBridgeFactory;

abstract class Config extends Events
{
	public static final PropType X = PropType.X;
	public static final PropType Y = PropType.Y;
	public static final PropType WIDTH = PropType.WIDTH;
	public static final PropType HEIGHT = PropType.HEIGHT;
	public static final PropType SCALE_X = PropType.SCALE_X;
	public static final PropType SCALE_Y = PropType.SCALE_Y;
	public static final PropType SKEW_X = PropType.SKEW_X;
	public static final PropType SKEW_Y = PropType.SKEW_Y;
	public static final PropType ROTATION = PropType.ROTATION;
	public static final PropType ALPHA = PropType.ALPHA;

	boolean error = false;
	private Object target;
	private TweenProp[] tweenProps;
	private Map<String, TweenProp> props = new HashMap<String, TweenProp>();

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public Config(Object target)
	{
		if(target == null) {
			// Log.error("Target should not be null");
			error = true;
			return;
		}
		this.target = target;
	}

	void finalizeManifest()
	{
		tweenProps = props.values().toArray(new TweenProp[props.size()]);
		props.clear();
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - TweenProps create Methods
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	protected void to(PropType propType, double end)
	{
		to(propType.getName(), end);
	}

	protected void parseTo(String toValues)
	{
		double end;
		String name;
		Map<String, Double> parsedProps = parse(toValues);
		Iterator<String> propNames = parsedProps.keySet().iterator();
		while (propNames.hasNext()) {
			name = propNames.next();
			end = parsedProps.get(name);
			to(name, end);
		}
	}

	protected void from(PropType propType, double start)
	{
		from(propType.getName(), start);
	}

	protected void parseFrom(String fromValues)
	{
		double start;
		String name;
		Map<String, Double> parsedProps = parse(fromValues);
		Iterator<String> propNames = parsedProps.keySet().iterator();
		while (propNames.hasNext()) {
			name = propNames.next();
			start = parsedProps.get(name);
			from(name, start);
		}
	}

	protected void fromTo(PropType propType, double start, double end)
	{
		fromTo(propType.getName(), start, end);
	}

	protected void parseFromTo(String fromValues, String toValues)
	{
		parseFrom(fromValues);
		parseTo(toValues);
	}

	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - TweenProps Parse String Functionality
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

	private void to(String name, double end)
	{
		TweenProp prop;
		if(name != null) {
			if(props.containsKey(name)) {
				prop = props.get(name);
				prop.setEnd(end);
			} else {
				IPropBridge propBridge = PropBridgeFactory.createBridgeByName(target, name);
				if(propBridge != null) {
					prop = new TweenProp(propBridge, propBridge.get(), end);
					props.put(name, prop);
				}
			}
		}
	}

	private void from(String name, double start)
	{
		TweenProp prop;
		if(name != null) {
			if(props.containsKey(name)) {
				prop = props.get(name);
				prop.setStart(start);
			} else {
				IPropBridge propBridge = PropBridgeFactory.createBridgeByName(target, name);
				if(propBridge != null) {
					prop = new TweenProp(propBridge, start, start);
					props.put(name, prop);
				}
			}
		}
	}

	private void fromTo(String name, double start, double end)
	{
		TweenProp prop;
		if(name != null) {
			if(props.containsKey(name)) {
				prop = props.get(name);
				prop.setStart(start);
				prop.setEnd(end);
			} else {
				IPropBridge propBridge = PropBridgeFactory.createBridgeByName(target, name);
				if(propBridge != null) {
					prop = new TweenProp(propBridge, start, end);
					props.put(name, prop);
				}
			}
		}
	}

	private Map<String, Double> parse(String rawProps)
	{
		Map<String, Double> properties = new HashMap<String, Double>();
		List<String> props = Arrays.asList(rawProps.replaceAll("\\s+", "").split("\\s*,\\s*"));
		for(int i = 0;i < props.size();i++) {
			String[] prop = props.get(i).split(":");
			String key = prop[0];
			String value = prop[1];

			try {
				properties.put(key, Double.parseDouble(value));
			} catch (Exception e) {
				// Log.error("An error occurred while parsing the property: " + key + " : " + value);
				continue;
			}
		}

		return properties;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public Object target()
	{
		return target;
	}

	public TweenProp[] tweenProps()
	{
		return tweenProps;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Implemented by subClass
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	protected abstract void configure();
}
