
package actionjava.anim.config;

import actionjava.anim.ease.Ease;

public abstract class Manifest extends Config
{
	private static final Ease DEFAULT_EASE = new Ease(1, 1);
	private static final double DEFAULT_DURATION = 1;
	private static final double DEFAULT_DELAY = 0;
	private static final boolean DEFAULT_PAUSED = false;

	protected boolean paused = DEFAULT_PAUSED;
	private Ease ease;
	private double duration;
	private double delay;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructors
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public Manifest(Object target)
	{
		super(target);
		initialize(DEFAULT_DURATION, DEFAULT_DELAY, DEFAULT_EASE);
	}

	public Manifest(Object target, double duration)
	{
		super(target);
		initialize(duration, DEFAULT_DELAY, DEFAULT_EASE);
	}

	public Manifest(Object target, double duration, Ease ease)
	{
		super(target);
		initialize(duration, DEFAULT_DELAY, ease);
	}

	public Manifest(Object target, double duration, double delay)
	{
		super(target);
		initialize(duration, delay, DEFAULT_EASE);
	}

	public Manifest(Object target, double duration, double delay, Ease ease)
	{
		super(target);
		initialize(duration, delay, ease);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	private void initialize(double duration, double delay, Ease ease)
	{
		if(error) { return; }
		this.duration = Math.abs(duration);
		this.delay = delay;
		this.ease = (ease != null) ? ease : this.ease;
		configure();
		finalizeManifest();
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public Ease ease()
	{
		return ease;
	}

	public double duration()
	{
		return duration;
	}

	public double delay()
	{
		return delay;
	}

	public boolean paused()
	{
		return paused;
	}
}
