
package actionjava.anim.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TweenContainer
{
	private List<Tween> childList;
	private Tween[] children;

	private double time;
	private boolean dirty;

	private boolean autoRemoveChildren = true;
	private boolean smoothChildTiming = true;
	private boolean sortChildren = false;

	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & Initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//

	public TweenContainer()
	{
		super();
		initialize();
	}

	private void initialize()
	{
		time = 0;
		dirty = false;
		children = new Tween[0];
		childList = new ArrayList<Tween>();
	}

	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Composite & Private Functionality
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//

	public void addChild(Tween child)
	{
		child.setStartTime(time);
		child.setParent(this);
		insertChild(child);
		export();
	}

	public void removeChild(Tween tween)
	{
		if(tween.getParent() == this) {
			if(childList.remove(tween)) {
				tween.setParent(null);
				export();
			}
		}
	}

	private void insertChild(Tween child)
	{
		if(sortChildren) {
			double st = child.getStartTime();
			Iterator<Tween> iterator = childList.iterator();
			while (iterator.hasNext()) {
				Tween tw = iterator.next();
				if(tw.getStartTime() < st) {
					childList.add(childList.indexOf(tw), child);
					return;
				}
			}
		}

		childList.add(child);
	}

	private Tween[] export()
	{
		return (children = childList.toArray(new Tween[childList.size()]));
	}

	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters (Settings)
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//

	public Iterator<Tween> getIterator()
	{
		return new TweenIterator();
	}

	public boolean autoRemoveChildren()
	{
		return autoRemoveChildren;
	}

	public void setAutoRemoveChildren(boolean autoRemoveChildren)
	{
		this.autoRemoveChildren = autoRemoveChildren;
	}

	public boolean smoothChildTiming()
	{
		return smoothChildTiming;
	}

	public void setSmoothChildTiming(boolean smoothChildTiming)
	{
		this.smoothChildTiming = smoothChildTiming;
	}

	public boolean sortChildren()
	{
		return sortChildren;
	}

	public void setSortChildren(boolean sortChildren)
	{
		this.sortChildren = sortChildren;
	}

	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters (Time related)
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//

	public double getTime()
	{
		return time;
	}

	public void setTime(double time)
	{
		this.time = time;
	}

	public boolean isDirty()
	{
		return dirty;
	}

	public void setDirty(boolean dirty)
	{
		this.dirty = dirty;
	}

	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Tween Iterator
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//

	private class TweenIterator implements Iterator<Tween>
	{
		private int pos = 0;

		@Override
		public boolean hasNext()
		{
			return (pos < children.length) ? true : false;
		}

		@Override
		public Tween next()
		{
			Tween child = children[pos];
			pos++;
			return child;
		}

		@Override
		public void remove()
		{
			// IGNORE
		}
	}
}

// private double totalTime;
// private double rawTime;
// private double rawPrevTime;
// private double timeScale;

// public double getStartTime()
// {
// return startTime;
// }
//
// public void setStartTime(double startTime)
// {
// this.startTime = startTime;
// }

// public double getTotalTime()
// {
// return totalTime;
// }
//
// public void setTotalTime(double totalTime)
// {
// this.totalTime = totalTime;
// }
//
// public double getRawTime()
// {
// return rawTime;
// }
//
// public void setRawTime(double rawTime)
// {
// this.rawTime = rawTime;
// }
//
// public double getRawPrevTime()
// {
// return rawPrevTime;
// }
//
// public void setRawPrevTime(double rawPrevTime)
// {
// this.rawPrevTime = rawPrevTime;
// }
//
// public double getTimeScale()
// {
// return timeScale;
// }
//
// public void setTimeScale(double timeScale)
// {
// this.timeScale = timeScale;
// }
