
package actionjava.anim.core;

import actionjava.anim.core.props.IPropBridge;

public class TweenProp
{
	private double start;
	private double end;
	private double change;
	private IPropBridge propBridge;

	public TweenProp(IPropBridge propBridge, double start, double end)
	{
		super();
		initialize(propBridge, start, end);
	}

	private void initialize(IPropBridge propBridge, double start, double end)
	{
		this.propBridge = propBridge;
		this.start = start;
		this.end = end;
		this.change = end - start;
	}

	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Proxy Methods
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public double get()
	{
		return propBridge.get();
	}

	public void set(double value)
	{
		propBridge.set(value);
	}

	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public double getStart()
	{
		return start;
	}

	public void setStart(double start)
	{
		this.start = start;
	}

	public double getChange()
	{
		return change;
	}

	public void setChange(double change)
	{
		this.change = change;
	}

	public double getEnd()
	{
		return end;
	}

	public void setEnd(double end)
	{
		this.end = end;
	}
}
