
package actionjava.anim.core.props;

import actionjava.display.DisplayObject;

class SkewY extends PropBridge implements IPropBridge
{
	private DisplayObject target;

	public SkewY(Object target)
	{
		super(target);
	}

	@Override
	public double get()
	{
		return target.getSkewY();
	}

	@Override
	public void set(double value)
	{
		target.setSkewY(value);
	}

	@Override
	boolean checkCompatibility(Object target)
	{
		if(target instanceof DisplayObject) {
			this.target = (DisplayObject) target;
			return true;
		}
		return false;
	}

	@Override
	public Object getTarget()
	{
		return target;
	}
}
