
package actionjava.anim.core.props;

import actionjava.display.DisplayObject;

class X extends PropBridge implements IPropBridge
{
	private DisplayObject target;

	public X(Object target)
	{
		super(target);
	}

	@Override
	public double get()
	{
		return target.getX();
	}

	@Override
	public void set(double value)
	{
		target.setX(value);
	}

	@Override
	boolean checkCompatibility(Object target)
	{
		if(target instanceof DisplayObject) {
			this.target = (DisplayObject) target;
			return true;
		}
		return false;
	}

	@Override
	public Object getTarget()
	{
		return target;
	}
}
