
package actionjava.anim.ease;

public class ElasticOut extends Ease
{
	private static final double PI2 = Math.PI * 2;
	public static ElasticOut ease = new ElasticOut();

	public ElasticOut()
	{
		super();
		initialize(1, 0.3);
	}

	public ElasticOut(double amplitude)
	{
		super();
		initialize(amplitude, 0.3);
	}

	public ElasticOut(double amplitude, double period)
	{
		super();
		initialize(amplitude, period);
	}

	private void initialize(double amplitude, double period)
	{
		p1 = amplitude;
		p2 = period;
		p3 = p2 / PI2 * Math.asin(1 / p1);
	}

	@Override
	public double getRatio(double p)
	{
		return p1 * Math.pow(2, -10 * p) * Math.sin((p - p3) * PI2 / p2) + 1;
	}
}
