
package actionjava.anim.events;

import java.util.Date;

public abstract class Event
{
	private EventType type;
	private String eventName;
	private String eventType;

	private Object target = null;
	private Object currentTarget = null;

	private int eventPhase = 0;
	private int timeStamp = 0;

	private boolean removed = false;
	private boolean bubbles = false;
	private boolean cancelable = false;
	private boolean defaultPrevented = false;
	private boolean propagationStopped = false;
	private boolean immediatePropagationStopped = false;

	public Event(String eventName, EventType type)
	{
		initialize(eventName, type, false, false);
	}

	public Event(String eventName, EventType type, boolean bubbles)
	{
		initialize(eventName, type, bubbles, false);
	}

	public Event(String eventName, EventType type, boolean bubbles, boolean cancelable)
	{
		initialize(eventName, type, bubbles, cancelable);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	private void initialize(String eventName, EventType type, boolean bubbles, boolean cancelable)
	{
		this.type = type;

		this.eventName = eventName;
		this.eventType = type.getType();
		this.timeStamp = (int) (new Date()).getTime();
		this.bubbles = bubbles;
		this.cancelable = cancelable;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - One Way Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public void preventDefault()
	{
		defaultPrevented = true;
	}

	public void stopPropagation()
	{
		propagationStopped = true;
	}

	public void stopImmediatePropagation()
	{
		stopPropagation();
		immediatePropagationStopped = true;
	}

	public void remove()
	{
		removed = true;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public void setTarget(Object target)
	{
		this.target = target;
	}

	public void setCurrentTarget(Object target)
	{
		this.currentTarget = target;
	}

	public void setEventPhase(int phase)
	{
		this.eventPhase = phase;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public String getEventName()
	{
		return eventName;
	}

	public EventType getType()
	{
		return type;
	}

	public String getEventType()
	{
		return eventType;
	}

	public Object getTarget()
	{
		return target;
	}

	public Object getCurrentTarget()
	{
		return currentTarget;
	}

	public int getEventPhase()
	{
		return eventPhase;
	}

	public int getTimeStamp()
	{
		return timeStamp;
	}

	public boolean getBubbles()
	{
		return bubbles;
	}

	public boolean getCancelable()
	{
		return cancelable;
	}

	public boolean getDefaultPrevented()
	{
		return defaultPrevented;
	}

	public boolean getPropagationStopped()
	{
		return propagationStopped;
	}

	public boolean getImmediatePropagationStopped()
	{
		return immediatePropagationStopped;
	}

	public boolean getRemoved()
	{
		return removed;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - EventType Interface
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public interface EventType
	{
		public String getType();
	}
}
