
package actionjava.anim.events;

import actionjava.anim.events.Event.EventType;

public abstract class EventHandler extends EventListener
{
	private EventType type;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructors
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public EventHandler(EventType type)
	{
		super(false);
		initialize(type);
	}

	public EventHandler(EventType type, boolean once)
	{
		super(once);
		initialize(type);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	private void initialize(EventType type)
	{
		this.type = type;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Public & abstract Protected Methods
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	protected abstract void delegateEvent(Event event);

	@Override
	public final void handleEvent(Event event)
	{
		delegateEvent(event);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public String getType()
	{
		return type.getType();
	}

	public EventType getEventType()
	{
		return type;
	}
}
