
package com.actionjava.mvn.plugins.assets;

import java.io.File;
import com.actionjava.mvn.plugins.assets.parsers.AssetParser;
import com.actionjava.mvn.plugins.assets.vo.AssetSettings;
import com.actionjava.mvn.plugins.assets.vo.GlobalSettings;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name = "convert")
public class AssetsMojo extends AbstractMojo
{
	private static final String SHAPE_TEMPLATE = "templates/shape.vm";
	private static final String SYMBOL_TEMPLATE = "templates/symbol.vm";

	@Parameter(defaultValue = "${basedir}", readonly = true)
	private File baseDirectory;

	@Parameter(defaultValue = "${project.build.directory}", readonly = true)
	private File targetDirectory;

	@Parameter
	private GlobalSettings settings;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Execute & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public void execute() throws MojoExecutionException, MojoFailureException
	{
		initialize();

		if(settings.getAutoDetect()) {
			detectAssets();
		}

		parseAssets();
	}

	private void initialize()
	{
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Private functionality
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	private void detectAssets()
	{
		// Ignore
	}

	private void parseAssets()
	{
		// getLog().info(ReflectionToStringBuilder.toString(settings, ToStringStyle.MULTI_LINE_STYLE));
		// AssetSettings[] settings2 = settings.getAssets();
		// for(int i = 0;i < settings2.length;i++) {
		// AssetSettings settings3 = settings2[i];
		// getLog().info(ReflectionToStringBuilder.toString(settings3, ToStringStyle.MULTI_LINE_STYLE));
		// }

		AssetSettings assetSettings;
		AssetParser assetParser;
		AssetSettings[] assets = settings.getAssets();
		if(assets != null) {
			for(int i = 0;i < assets.length;i++) {
				assetSettings = assets[i];
				assetParser = new AssetParser(assetSettings, baseDirectory);
				assetParser.read();
				assetParser.parse();
				assetParser.write();
			}
		}
	}
}
