
package com.actionjava.mvn.plugins.assets.data;

import com.actionjava.mvn.plugins.assets.vo.Bounds;
import com.actionjava.mvn.plugins.assets.vo.Transform;

public abstract class Instance
{
	private String id;
	private String name;

	private Bounds bounds;
	private Transform transform;

	public Instance(String id, String name)
	{
		initialize(id, name);
	}

	private void initialize(String id, String name)
	{
		this.id = id;
		this.name = name.substring(0, 1).toUpperCase() + name.substring(1);

		setTransform();
		setBounds();
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public String getID()
	{
		return id;
	}

	public String getName()
	{
		return name;
	}

	public Bounds getBounds()
	{
		return bounds;
	}

	public Transform getTransform()
	{
		return transform;
	}

	public void setTransform()
	{
		setTransform(0, 0, 1, 1, 0, 0, 0, 0, 0);
	}

	public void setTransform(Transform transform)
	{
		if(transform != null) {
			setTransform(transform.getX(), transform.getY(), transform.getScaleX(), transform.getScaleY(), transform.getRotation(), transform.getSkewX(), transform.getSkewY(), transform.getRegX(), transform.getRegY());
		}
	}

	public void setTransform(double x, double y)
	{
		setTransform(x, y, 1, 1, 0, 0, 0, 0, 0);
	}

	public void setTransform(double x, double y, double scaleX, double scaleY)
	{
		setTransform(x, y, scaleX, scaleY, 0, 0, 0, 0, 0);
	}

	public void setTransform(double x, double y, double scaleX, double scaleY, double rotation)
	{
		setTransform(x, y, scaleX, scaleY, rotation, 0, 0, 0, 0);
	}

	public void setTransform(double x, double y, double scaleX, double scaleY, double rotation, double skewX, double skewY)
	{
		setTransform(x, y, scaleX, scaleY, rotation, skewX, skewY, 0, 0);
	}

	public void setTransform(double x, double y, double scaleX, double scaleY, double rotation, double skewX, double skewY, double regX, double regY)
	{
		transform = new Transform(x, y, scaleX, scaleY, rotation, skewX, skewY, regX, regY);
	}

	public void setBounds()
	{
		setBounds(0, 0, 0, 0);
	}

	public void setBounds(Bounds bounds)
	{
		if(bounds != null) {
			setBounds(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
		}
	}

	public void setBounds(double x, double y)
	{
		setBounds(x, y, 0, 0);
	}

	public void setBounds(double x, double y, double width, double height)
	{
		bounds = new Bounds(x, y, width, height);
	}
}
