
package com.actionjava.mvn.plugins.assets.data;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.math.NumberUtils;

public class Parameter
{
	public static final int UNKNOWN = 0;
	public static final int NUMBER = 1;
	public static final int NUMBER_ARRAY = 2;
	public static final int STRING = 3;
	public static final int STRING_ARRAY = 4;
	public static final int BOOLEAN = 5;

	private int type = UNKNOWN;
	private Object value = null;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public Parameter(Object value)
	{
		super();
		initialize(value);
	}

	private void initialize(Object value)
	{
		this.value = value;
		identifyValueType();
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Private methods
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	private void identifyValueType()
	{
		String stringValue;
		try {
			stringValue = (String) value;
		} catch (Exception e) {
			System.out.println("here!!: " + value);
			return;
		}

		if(stringValue.equals("true") || stringValue.equals("false")) {
			type = BOOLEAN;
		} else if(NumberUtils.isNumber(stringValue)) {
			type = NUMBER;
		} else {
			type = STRING;
			if(checkStringForArray(stringValue)) {
				if(value instanceof Double[]) {
					type = NUMBER_ARRAY;
				} else if(value instanceof String[]) {
					type = STRING_ARRAY;
				}
			} else {
				value = stringValue.replaceAll("[\'|\"]", "");
			}
		}
	}

	private boolean checkStringForArray(String rawValue)
	{
		Pattern pattern = Pattern.compile("\\[.*\\]");
		Matcher matcher = pattern.matcher(rawValue);

		if(matcher.matches()) {
			value = createArray(rawValue);
			return true;
		}

		return false;
	}

	private Object[] createArray(String rawValue)
	{
		rawValue = rawValue.replaceAll("[\\[|\\]]", "");

		Pattern pattern = Pattern.compile("\"");
		Matcher matcher = pattern.matcher(rawValue);

		if(matcher.find()) { return createStringArray(rawValue); }

		return createNumberArray(rawValue);
	}

	private String[] createStringArray(String rawValue)
	{
		String[] valuesSplit = rawValue.split(",(?![^\'|\"]*[^\'|\"])");
		String[] stringValues = new String[valuesSplit.length];
		for(int i = 0;i < valuesSplit.length;i++) {
			stringValues[i] = valuesSplit[i].replaceAll("[\'|\"]", "");
		}

		return stringValues;
	}

	private Double[] createNumberArray(String rawValue)
	{
		String[] valuesSplit = rawValue.split(",");
		Double[] doubleValues = new Double[valuesSplit.length];
		for(int i = 0;i < valuesSplit.length;i++) {
			doubleValues[i] = Double.valueOf(valuesSplit[i]);
		}

		return doubleValues;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public int getType()
	{
		return type;
	}

	public Object getRawValue()
	{
		return value;
	}

	public Boolean getBooleanValue()
	{
		if(type == BOOLEAN) { return Boolean.valueOf((String) value); }

		return null;
	}

	public String getStringValue()
	{
		if(type == STRING) { return (String) value; }

		return null;
	}

	public String[] getStringArrayValue()
	{
		if(type == STRING_ARRAY) { return ((String[]) value); }

		return null;
	}

	public Double getNumberValue()
	{
		if(type == NUMBER) { return Double.valueOf((String) value); }

		return null;
	}

	public Double[] getNumberArrayValue()
	{
		if(type == NUMBER_ARRAY) { return ((Double[]) value); }

		return null;
	}
}
