
package com.actionjava.mvn.plugins.assets.data;

import java.util.ArrayList;
import java.util.List;

public class Symbol extends Instance
{
	public static final String MC_TYPE = "movieclip";
	public static final String SPRITE_TYPE = "sprite";
	public static final String BITMAP_TYPE = "bitmap";
	public static final String UNKNOWN_TYPE = "unknown";

	private final List<Instance> children = new ArrayList<Instance>();
	private String symbolPackage;
	private String type;
	private String bitmapUrl = null;
	private String[] rawData;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public Symbol(String id, String name, String symbolPackage)
	{
		super(id, name);
		initialize(symbolPackage);
	}

	private void initialize(String symbolPackage)
	{
		this.symbolPackage = symbolPackage;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Public methods
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public void addChild(Instance child)
	{
		children.add(child);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public String getPackage()
	{
		return symbolPackage;
	}

	public void setPackage(String symbolPackage)
	{
		this.symbolPackage = symbolPackage;
	}

	public Instance[] getChildren()
	{
		return children.toArray(new Instance[children.size()]);
	}

	public String getType()
	{
		return type;
	}

	public void setType(String type)
	{
		this.type = type;
	}

	public String getBitmapUrl()
	{
		return bitmapUrl;
	}

	public void setBitmapUrl(String bitmapUrl)
	{
		this.bitmapUrl = bitmapUrl;
	}

	public String[] getRawData()
	{
		return rawData;
	}

	public void setRawData(String[] rawData)
	{
		this.rawData = rawData;
	}
}
