
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class Arc extends Instruction
{
	public static final String ID = "a";
	public static final String NAME = "arc";

	private double x;
	private double y;
	private double radius;
	private double startAngle;
	private double endAngle;
	private boolean anticlockwise;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public Arc()
	{
		super(ID, NAME);
		initialize(0, 0, 0, 0, 0, false);
	}

	public Arc(double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise)
	{
		super(ID, NAME);
		initialize(x, y, radius, startAngle, endAngle, anticlockwise);
	}

	private void initialize(double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise)
	{
		this.x = x;
		this.y = y;
		this.radius = radius;
		this.startAngle = startAngle;
		this.endAngle = endAngle;
		this.anticlockwise = anticlockwise;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract overrides
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public Instruction createNew(Parameter[] params) throws Exception
	{
		if(params.length != 6) { throw new Exception("Param count does not match the Instruction"); }
		return new Arc(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), params[4].getNumberValue(), params[5].getBooleanValue());
	}

	@Override
	public String toMethod()
	{
		return super.toMethod() + getMethodParams();
	}

	@Override
	public String getMethodParams()
	{
		String methodParams = "(";
		methodParams += x + ",";
		methodParams += y + ",";
		methodParams += radius + ",";
		methodParams += startAngle + ",";
		methodParams += endAngle + ",";
		methodParams += anticlockwise;
		methodParams += ")";

		return methodParams;
	}

	@Override
	public String toString()
	{
		return "Arc [x: " + x + ", y: " + y + ", radius: " + radius + ", startAngle: " + startAngle + ", endAngle: " + endAngle + ", anticlockwise: " + anticlockwise + "]";
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public double getX()
	{
		return x;
	}

	public void setX(double x)
	{
		this.x = x;
	}

	public double getY()
	{
		return y;
	}

	public void setY(double y)
	{
		this.y = y;
	}

	public double getRadius()
	{
		return radius;
	}

	public void setRadius(double radius)
	{
		this.radius = radius;
	}

	public double getStartAngle()
	{
		return startAngle;
	}

	public void setStartAngle(double startAngle)
	{
		this.startAngle = startAngle;
	}

	public double getEndAngle()
	{
		return endAngle;
	}

	public void setEndAngle(double endAngle)
	{
		this.endAngle = endAngle;
	}

	public boolean isAnticlockwise()
	{
		return anticlockwise;
	}

	public void setAnticlockwise(boolean anticlockwise)
	{
		this.anticlockwise = anticlockwise;
	}

}
