
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class ArcTo extends Instruction
{
	public static final String ID = "at";
	public static final String NAME = "arcTo";

	private double x1;
	private double y1;
	private double x2;
	private double y2;
	private double radius;
	private boolean anticlockwise;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public ArcTo()
	{
		super(ID, NAME);
		initialize(0, 0, 0, 0, 0);
	}

	public ArcTo(double x1, double y1, double x2, double y2, double radius)
	{
		super(ID, NAME);
		initialize(x1, y1, x2, y2, radius);
	}

	private void initialize(double x1, double y1, double x2, double y2, double radius)
	{
		this.x1 = x1;
		this.y1 = y1;
		this.x2 = x2;
		this.y2 = y2;
		this.radius = radius;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract overrides
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public Instruction createNew(Parameter[] params) throws Exception
	{
		if(params.length != 5) { throw new Exception("Param count does not match the Instruction"); }
		return new ArcTo(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), params[4].getNumberValue());
	}

	@Override
	public String toMethod()
	{
		return super.toMethod() + getMethodParams();
	}

	@Override
	public String getMethodParams()
	{
		String methodParams = "(";
		methodParams += x1 + ",";
		methodParams += y1 + ",";
		methodParams += x2 + ",";
		methodParams += y2 + ",";
		methodParams += radius;
		methodParams += ")";

		return methodParams;
	}

	@Override
	public String toString()
	{
		return "ArcTo [x1: " + x1 + ", y1: " + y1 + ", x2: " + x2 + ", y2: " + y2 + ", radius: " + radius + ", anticlockwise: " + anticlockwise + "]";
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public double getX1()
	{
		return x1;
	}

	public void setX1(double x1)
	{
		this.x1 = x1;
	}

	public double getY1()
	{
		return y1;
	}

	public void setY1(double y1)
	{
		this.y1 = y1;
	}

	public double getX2()
	{
		return x2;
	}

	public void setX2(double x2)
	{
		this.x2 = x2;
	}

	public double getY2()
	{
		return y2;
	}

	public void setY2(double y2)
	{
		this.y2 = y2;
	}

	public double getRadius()
	{
		return radius;
	}

	public void setRadius(double radius)
	{
		this.radius = radius;
	}

	public boolean isAnticlockwise()
	{
		return anticlockwise;
	}

	public void setAnticlockwise(boolean anticlockwise)
	{
		this.anticlockwise = anticlockwise;
	}
}
