
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class BeginFill extends Instruction
{
	public static final String ID = "f";
	public static final String NAME = "beginFill";

	private String cssColor = null;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public BeginFill()
	{
		super(ID, NAME);
		initialize("#FFFFFF");
	}

	public BeginFill(String cssColor)
	{
		super(ID, NAME);
		initialize(cssColor);
	}

	private void initialize(String cssColor)
	{
		this.cssColor = cssColor;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract overrides
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public Instruction createNew(Parameter[] params) throws Exception
	{
		if(params != null) {
			if(params.length > 1) {
				throw new Exception("Param count does not match the Instruction");
			} else if(params.length == 1) { return new BeginFill(params[0].getStringValue()); }
		}

		return new BeginFill(null);
	}

	@Override
	public String toMethod()
	{
		return super.toMethod() + getMethodParams();
	}

	@Override
	public String getMethodParams()
	{
		if((cssColor == null) || (cssColor.equals(""))) { return super.getMethodParams(); }

		String methodParams = "(";
		methodParams += "\"" + cssColor + "\"";
		methodParams += ")";

		return methodParams;
	}

	@Override
	public String toString()
	{
		if((cssColor == null) || (cssColor.equals(""))) { return "BeginFill []"; }

		return "BeginFill [cssColor: \"" + cssColor + "\"]";
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public String getCssColor()
	{
		return cssColor;
	}

	public void setCssColor(String cssColor)
	{
		this.cssColor = cssColor;
	}
}
