
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class BeginLinearGradientFill extends Instruction
{
	public static final String ID = "lf";
	public static final String NAME = "beginLinearGradientFill";

	private String[] colors;
	private Double[] ratios;
	private double x0;
	private double y0;
	private double x1;
	private double y1;

	public BeginLinearGradientFill()
	{
		super(ID, NAME);
		initialize(null, null, 0, 0, 0, 0);
	}

	public BeginLinearGradientFill(String[] colors, Double[] ratios, double x0, double y0, double x1, double y1)
	{
		super(ID, NAME);
		initialize(colors, ratios, x0, y0, x1, y1);
	}

	private void initialize(String[] colors, Double[] ratios, double x0, double y0, double x1, double y1)
	{
		this.colors = colors;
		this.ratios = ratios;
		this.x0 = x0;
		this.y0 = y0;
		this.x1 = x1;
		this.y1 = y1;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract overrides
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public Instruction createNew(Parameter[] params) throws Exception
	{
		if(params.length != 6) { throw new Exception("Param count does not match the Instruction"); }
		return new BeginLinearGradientFill(params[0].getStringArrayValue(), params[1].getNumberArrayValue(), params[2].getNumberValue(), params[3].getNumberValue(), params[4].getNumberValue(), params[5].getNumberValue());
	}

	@Override
	public String toMethod()
	{
		return super.toMethod() + getMethodParams();
	}

	@Override
	public String getMethodParams()
	{
		String methodParams = "(";
		methodParams += convertStringArray(colors) + ",";
		methodParams += convertDoubleArray(ratios) + ",";
		methodParams += x0 + ",";
		methodParams += y0 + ",";
		methodParams += x1 + ",";
		methodParams += y1;
		methodParams += ")";

		return methodParams;
	}

	@Override
	public String toString()
	{
		return "BeginLinearGradientFill [colors: " + convertStringArray(colors) + ", ratios: " + convertDoubleArray(ratios) + ", x0: " + x0 + ", y0: " + y0 + ", x1: " + x1 + ", y1: " + y1 + "]";
	}
}
