
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class BeginStroke extends Instruction
{
	public static final String ID = "s";
	public static final String NAME = "beginStroke";

	private String cssColor;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public BeginStroke()
	{
		super(ID, NAME);
		initialize("#000000");
	}

	public BeginStroke(String cssColor)
	{
		super(ID, NAME);
		initialize(cssColor);
	}

	private void initialize(String cssColor)
	{
		this.cssColor = cssColor;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract overrides
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public Instruction createNew(Parameter[] params) throws Exception
	{
		if(params != null) {
			if(params.length > 1) {
				throw new Exception("Param count does not match the Instruction");
			} else if(params.length == 1) { return new BeginStroke(params[0].getStringValue()); }
		}

		return new BeginStroke(null);
	}

	@Override
	public String toMethod()
	{
		return super.toMethod() + getMethodParams();
	}

	@Override
	public String getMethodParams()
	{
		if((cssColor == null) || (cssColor.equals(""))) { return super.getMethodParams(); }

		String methodParams = "(";
		methodParams += "\"" + cssColor + "\"";
		methodParams += ")";

		return methodParams;
	}

	@Override
	public String toString()
	{
		if((cssColor == null) || (cssColor.equals(""))) { return "BeginStroke []"; }

		return "BeginStroke [cssColor: \"" + cssColor + "\"]";
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public String getCssColor()
	{
		return cssColor;
	}

	public void setCssColor(String cssColor)
	{
		this.cssColor = cssColor;
	}
}
