
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class BezierCurveTo extends Instruction
{
	public static final String ID = "bt";
	public static final String NAME = "bezierCurveTo";

	private double cp1x;
	private double cp1y;
	private double cp2x;
	private double cp2y;
	private double x;
	private double y;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public BezierCurveTo()
	{
		super(ID, NAME);
		initialize(0, 0, 0, 0, 0, 0);
	}

	public BezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y)
	{
		super(ID, NAME);
		initialize(cp1x, cp1y, cp2x, cp2y, x, y);
	}

	private void initialize(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y)
	{
		this.cp1x = cp1x;
		this.cp1y = cp1y;
		this.cp2x = cp2x;
		this.cp2y = cp2y;
		this.x = x;
		this.y = y;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract overrides
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public Instruction createNew(Parameter[] params) throws Exception
	{
		if(params.length != 6) { throw new Exception("Param count does not match the Instruction"); }
		return new BezierCurveTo(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), params[4].getNumberValue(), params[5].getNumberValue());
	}

	@Override
	public String toMethod()
	{
		return super.toMethod() + getMethodParams();
	}

	@Override
	public String getMethodParams()
	{
		String methodParams = "(";
		methodParams += cp1x + ",";
		methodParams += cp1y + ",";
		methodParams += cp2x + ",";
		methodParams += cp2y + ",";
		methodParams += x + ",";
		methodParams += y;
		methodParams += ")";

		return methodParams;
	}

	@Override
	public String toString()
	{
		return "BezierCurveTo [cp1x: " + cp1x + ", cp1y: " + cp1y + ", cp2x: " + cp2x + ", cp2y: " + cp2y + ", x: " + x + ", y: " + y + "]";
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public double getCp1x()
	{
		return cp1x;
	}

	public void setCp1x(double cp1x)
	{
		this.cp1x = cp1x;
	}

	public double getCp1y()
	{
		return cp1y;
	}

	public void setCp1y(double cp1y)
	{
		this.cp1y = cp1y;
	}

	public double getCp2x()
	{
		return cp2x;
	}

	public void setCp2x(double cp2x)
	{
		this.cp2x = cp2x;
	}

	public double getCp2y()
	{
		return cp2y;
	}

	public void setCp2y(double cp2y)
	{
		this.cp2y = cp2y;
	}

	public double getX()
	{
		return x;
	}

	public void setX(double x)
	{
		this.x = x;
	}

	public double getY()
	{
		return y;
	}

	public void setY(double y)
	{
		this.y = y;
	}
}
