
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class DecodePath extends Instruction
{
	public static final String ID = "p";
	public static final String NAME = "decodePath";

	private String path;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public DecodePath()
	{
		super(ID, NAME);
		initialize("");
	}

	public DecodePath(String path)
	{
		super(ID, NAME);
		initialize(path);
	}

	private void initialize(String path)
	{
		this.path = path;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract overrides
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public Instruction createNew(Parameter[] params) throws Exception
	{
		if(params.length != 1) { throw new Exception("Param count does not match the Instruction"); }

		return new DecodePath(params[0].getStringValue());
	}

	@Override
	public String toMethod()
	{
		return super.toMethod() + getMethodParams();
	}

	@Override
	public String getMethodParams()
	{
		String methodParams = "(";
		methodParams += "\"" + path + "\"";
		methodParams += ")";

		return methodParams;
	}

	@Override
	public String toString()
	{
		return "DecodePath [path: \"" + path + "\"]";
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public String getPath()
	{
		return path;
	}

	public void setPath(String path)
	{
		this.path = path;
	}
}
