
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class DrawCircle extends Instruction
{
	public static final String ID = "dc";
	public static final String NAME = "drawCircle";

	private double x;
	private double y;
	private double radius;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public DrawCircle()
	{
		super(ID, NAME);
		initialize(0, 0, 0);
	}

	public DrawCircle(double x, double y, double radius)
	{
		super(ID, NAME);
		initialize(x, y, radius);
	}

	private void initialize(double x, double y, double radius)
	{
		this.x = x;
		this.y = y;
		this.radius = radius;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract overrides
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public Instruction createNew(Parameter[] params) throws Exception
	{
		if(params.length != 3) { throw new Exception("Param count does not match the Instruction"); }
		return new DrawCircle(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue());
	}

	@Override
	public String toMethod()
	{
		return super.toMethod() + getMethodParams();
	}

	@Override
	public String getMethodParams()
	{
		String methodParams = "(";
		methodParams += x + ",";
		methodParams += y + ",";
		methodParams += radius;
		methodParams += ")";

		return methodParams;
	}

	@Override
	public String toString()
	{
		return "DrawCircle [x: " + x + ", y: " + y + ", radius: " + radius + "]";
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public double getX()
	{
		return x;
	}

	public void setX(double x)
	{
		this.x = x;
	}

	public double getY()
	{
		return y;
	}

	public void setY(double y)
	{
		this.y = y;
	}

	public double getRadius()
	{
		return radius;
	}

	public void setRadius(double radius)
	{
		this.radius = radius;
	}
}
