
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class DrawPolyStar extends Instruction
{
	public static final String ID = "dp";
	public static final String NAME = "drawPolyStar";

	private double x;
	private double y;
	private double radius;
	private double sides;
	private double pointSize;
	private double angle;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public DrawPolyStar()
	{
		super(ID, NAME);
		initialize(0, 0, 0, 0, 0, 0);
	}

	public DrawPolyStar(double x, double y, double radius, double sides, double pointSize, double angle)
	{
		super(ID, NAME);
		initialize(x, y, radius, sides, pointSize, angle);
	}

	private void initialize(double x, double y, double radius, double sides, double pointSize, double angle)
	{
		this.x = x;
		this.y = y;
		this.radius = radius;
		this.sides = sides;
		this.pointSize = pointSize;
		this.angle = angle;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract overrides
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public Instruction createNew(Parameter[] params) throws Exception
	{
		if(params.length != 6) { throw new Exception("Param count does not match the Instruction"); }
		return new DrawPolyStar(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), params[4].getNumberValue(), params[5].getNumberValue());
	}

	@Override
	public String toMethod()
	{
		return super.toMethod() + getMethodParams();
	}

	@Override
	public String getMethodParams()
	{
		String methodParams = "(";
		methodParams += x + ",";
		methodParams += y + ",";
		methodParams += radius + ",";
		methodParams += sides + ",";
		methodParams += pointSize + ",";
		methodParams += angle;
		methodParams += ")";

		return methodParams;
	}

	@Override
	public String toString()
	{
		return "DrawPolyStar [x: " + x + ", y: " + y + ", radius: " + radius + ", sides: " + sides + ", pointSize: " + pointSize + ", angle: " + angle + "]";
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public double getX()
	{
		return x;
	}

	public void setX(double x)
	{
		this.x = x;
	}

	public double getY()
	{
		return y;
	}

	public void setY(double y)
	{
		this.y = y;
	}

	public double getRadius()
	{
		return radius;
	}

	public void setRadius(double radius)
	{
		this.radius = radius;
	}

	public double getSides()
	{
		return sides;
	}

	public void setSides(double sides)
	{
		this.sides = sides;
	}

	public double getPointSize()
	{
		return pointSize;
	}

	public void setPointSize(double pointSize)
	{
		this.pointSize = pointSize;
	}

	public double getAngle()
	{
		return angle;
	}

	public void setAngle(double angle)
	{
		this.angle = angle;
	}
}
