
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class DrawRoundRect extends Instruction
{
	public static final String ID = "rr";
	public static final String NAME = "drawRoundRect";

	private double x;
	private double y;
	private double width;
	private double height;
	private double radius;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public DrawRoundRect()
	{
		super(ID, NAME);
		initialize(0, 0, 0, 0, 0);
	}

	public DrawRoundRect(double x, double y, double width, double height, double radius)
	{
		super(ID, NAME);
		initialize(x, y, width, height, radius);
	}

	private void initialize(double x, double y, double width, double height, double radius)
	{
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
		this.radius = radius;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract overrides
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public Instruction createNew(Parameter[] params) throws Exception
	{
		if(params.length != 5) { throw new Exception("Param count does not match the Instruction"); }
		return new DrawRoundRect(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), params[4].getNumberValue());
	}

	@Override
	public String toMethod()
	{
		return super.toMethod() + getMethodParams();
	}

	@Override
	public String getMethodParams()
	{
		String methodParams = "(";
		methodParams += x + ",";
		methodParams += y + ",";
		methodParams += width + ",";
		methodParams += height + ",";
		methodParams += radius;
		methodParams += ")";

		return methodParams;
	}

	@Override
	public String toString()
	{
		return "DrawRoundRect [x: " + x + ", y: " + y + ", width: " + width + ", height: " + height + ", radius: " + radius + "]";
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public double getX()
	{
		return x;
	}

	public void setX(double x)
	{
		this.x = x;
	}

	public double getY()
	{
		return y;
	}

	public void setY(double y)
	{
		this.y = y;
	}

	public double getWidth()
	{
		return width;
	}

	public void setWidth(double width)
	{
		this.width = width;
	}

	public double getHeight()
	{
		return height;
	}

	public void setHeight(double height)
	{
		this.height = height;
	}

	public double getRadius()
	{
		return radius;
	}

	public void setRadius(double radius)
	{
		this.radius = radius;
	}
}
