
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public abstract class Instruction
{
	private String id;
	private String name;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public Instruction(String id, String name)
	{
		super();
		initialize(id, name);
	}

	private void initialize(String id, String name)
	{
		this.id = id;
		this.name = name;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Public methods
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public String toMethod()
	{
		return getName();
	}

	public String getMethodParams()
	{
		return "()";
	}

	public String convertStringArray(String[] strArr)
	{
		String result = "new String[] {";
		for(int i = 0;i < strArr.length;i++) {
			result += "\"" + strArr[i] + "\"";
			if(i != (strArr.length - 1)) {
				result += ",";
			}
		}
		result += "}";

		return result;
	}

	public String convertDoubleArray(Double[] doubleArr)
	{
		String result = "new Double[] {";
		for(int i = 0;i < doubleArr.length;i++) {
			result += doubleArr[i];
			if(i != (doubleArr.length - 1)) {
				result += ",";
			}
		}
		result += "}";

		return result;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract methods
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public abstract Instruction createNew(Parameter[] params) throws Exception;

	public abstract String toString();

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public String getId()
	{
		return id;
	}

	public String getName()
	{
		return name;
	}
}
