
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class LineTo extends Instruction
{
	public static final String ID = "lt";
	public static final String NAME = "lineTo";

	private double x;
	private double y;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public LineTo()
	{
		super(ID, NAME);
		initialize(0, 0);
	}

	public LineTo(double x, double y)
	{
		super(ID, NAME);
		initialize(x, y);
	}

	private void initialize(double x, double y)
	{
		this.x = x;
		this.y = y;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract overrides
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public Instruction createNew(Parameter[] params) throws Exception
	{
		if(params.length != 2) { throw new Exception("Param count does not match the Instruction"); }
		return new LineTo(params[0].getNumberValue(), params[1].getNumberValue());
	}

	@Override
	public String toMethod()
	{
		return super.toMethod() + getMethodParams();
	}

	@Override
	public String getMethodParams()
	{
		String methodParams = "(";
		methodParams += x + ",";
		methodParams += y;
		methodParams += ")";

		return methodParams;
	}

	@Override
	public String toString()
	{
		return "LineTo [x: " + x + ", y: " + y + "]";
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public double getX()
	{
		return x;
	}

	public void setX(double x)
	{
		this.x = x;
	}

	public double getY()
	{
		return y;
	}

	public void setY(double y)
	{
		this.y = y;
	}
}
