
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class QuadraticCurveTo extends Instruction
{
	public static final String ID = "qt";
	public static final String NAME = "quadraticCurveTo";

	private double cpx;
	private double cpy;
	private double x;
	private double y;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public QuadraticCurveTo()
	{
		super(ID, NAME);
		initialize(0, 0, 0, 0);
	}

	public QuadraticCurveTo(double cpx, double cpy, double x, double y)
	{
		super(ID, NAME);
		initialize(cpx, cpy, x, y);
	}

	private void initialize(double cpx, double cpy, double x, double y)
	{
		this.cpx = cpx;
		this.cpy = cpy;
		this.x = x;
		this.y = y;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract overrides
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public Instruction createNew(Parameter[] params) throws Exception
	{
		if(params.length != 4) { throw new Exception("Param count does not match the Instruction"); }
		return new QuadraticCurveTo(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue());
	}

	@Override
	public String toMethod()
	{
		return super.toMethod() + getMethodParams();
	}

	@Override
	public String getMethodParams()
	{
		String methodParams = "(";
		methodParams += cpx + ",";
		methodParams += cpy + ",";
		methodParams += x + ",";
		methodParams += y;
		methodParams += ")";

		return methodParams;
	}

	@Override
	public String toString()
	{
		return "QuadraticCurveTo [cpx: " + cpx + ", cpy: " + cpy + ", x: " + x + ", y: " + y + "]";
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public double getCpx()
	{
		return cpx;
	}

	public void setCpx(double cpx)
	{
		this.cpx = cpx;
	}

	public double getCpy()
	{
		return cpy;
	}

	public void setCpy(double cpy)
	{
		this.cpy = cpy;
	}

	public double getX()
	{
		return x;
	}

	public void setX(double x)
	{
		this.x = x;
	}

	public double getY()
	{
		return y;
	}

	public void setY(double y)
	{
		this.y = y;
	}
}
