
package com.actionjava.mvn.plugins.assets.data.instr;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class SetStrokeStyle extends Instruction
{
	public static final String ID = "ss";
	public static final String NAME = "setStrokeStyle";

	private double lineWidth;
	private double lineCap;
	private double lineJoin;
	private double miterLimit;
	private boolean ignoreScale;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public SetStrokeStyle()
	{
		super(ID, NAME);
		initialize(1, 0, 0, 10, false);
	}

	public SetStrokeStyle(double lineWidth, double lineCap, double lineJoin, double miterLimit, boolean ignoreScale)
	{
		super(ID, NAME);
		initialize(lineWidth, lineCap, lineJoin, miterLimit, ignoreScale);
	}

	private void initialize(double lineWidth, double lineCap, double lineJoin, double miterLimit, boolean ignoreScale)
	{
		this.lineWidth = lineWidth;
		this.lineCap = lineCap;
		this.lineJoin = lineJoin;
		this.miterLimit = miterLimit;
		this.ignoreScale = ignoreScale;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Abstract overrides
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	@Override
	public Instruction createNew(Parameter[] params) throws Exception
	{
		if(params.length == 0) {
			return new SetStrokeStyle(1, 0, 0, 10, false);

		} else if(params.length == 1) {
			return new SetStrokeStyle(params[0].getNumberValue(), 0, 0, 10, false);

		} else if(params.length == 2) {
			return new SetStrokeStyle(params[0].getNumberValue(), params[1].getNumberValue(), 0, 10, false);

		} else if(params.length == 3) {
			return new SetStrokeStyle(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), 10, false);

		} else if(params.length == 4) {
			return new SetStrokeStyle(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), false);

		} else if(params.length == 5) {
			return new SetStrokeStyle(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), params[4].getBooleanValue());

		} else {
			throw new Exception("Param count does not match the Instruction");
		}
	}

	@Override
	public String toMethod()
	{
		return super.toMethod() + getMethodParams();
	}

	@Override
	public String getMethodParams()
	{
		String methodParams = "(";
		methodParams += lineWidth + ",";
		methodParams += "LineCap.ROUND,";
		methodParams += "LineCap.ROUND,";
		methodParams += miterLimit + ",";
		methodParams += ignoreScale;
		methodParams += ")";

		return methodParams;
	}

	@Override
	public String toString()
	{
		return "SetStrokeStyle [lineWidth: " + lineWidth + ", lineCap: " + lineCap + ", lineJoin: " + lineJoin + ", miterLimit: " + miterLimit + ", ignoreScale: " + ignoreScale + "]";
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public double getLineWidth()
	{
		return lineWidth;
	}

	public void setLineWidth(double lineWidth)
	{
		this.lineWidth = lineWidth;
	}

	public double getLineCap()
	{
		return lineCap;
	}

	public void setLineCap(double lineCap)
	{
		this.lineCap = lineCap;
	}

	public double getLineJoin()
	{
		return lineJoin;
	}

	public void setLineJoin(double lineJoin)
	{
		this.lineJoin = lineJoin;
	}

	public double getMiterLimit()
	{
		return miterLimit;
	}

	public void setMiterLimit(double miterLimit)
	{
		this.miterLimit = miterLimit;
	}

	public boolean isIgnoreScale()
	{
		return ignoreScale;
	}

	public void setIgnoreScale(boolean ignoreScale)
	{
		this.ignoreScale = ignoreScale;
	}
}
