
package com.actionjava.mvn.plugins.assets.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;

public class AssetReader
{
	private final static Charset ENCODING = StandardCharsets.UTF_8;

	private File assetJS;
	private List<String> assetLines;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public AssetReader(File assetJS)
	{
		super();
		initialize(assetJS);
	}

	private void initialize(File assetJS)
	{
		this.assetJS = assetJS;
		this.assetLines = new ArrayList<String>();
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Public functionality
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public void read()
	{
		Scanner scanner;
		try {
			scanner = new Scanner(Paths.get(assetJS.getAbsolutePath()), ENCODING.name());
			while (scanner.hasNextLine()) {
				processLine(scanner.nextLine());
			}
			scanner.close();

		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Private functionality
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	private void processLine(String assetLine)
	{
		if(!Pattern.matches("\\s*", assetLine)) {
			assetLines.add(assetLine);
		}
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public String[] getAssetLines()
	{
		return assetLines.toArray(new String[assetLines.size()]);
	}
}
