
package com.actionjava.mvn.plugins.assets.io;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import com.actionjava.mvn.plugins.assets.data.Instance;
import com.actionjava.mvn.plugins.assets.data.Symbol;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;

public class AssetWriter
{
	private static final long serialVersionUID = 4748880101699843087L;

	private static final String VM_ENCODING = "utf-8";
	private static final String VM_PROPERTIES = "/velocity.properties";

	private static final String VM_SYMBOL_TEMPLATE = "/templates/symbol.vm";
	private static final String VM_BITMAP_TEMPLATE = "/templates/bitmap.vm";
	private static final String VM_SHAPE_TEMPLATE = "/templates/components/shape.vm";

	private File outputDirectory;
	private File packageDirectory;

	private VelocityEngine velocityEngine;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public AssetWriter(File outputDirectory)
	{
		super();
		initialize(outputDirectory);
	}

	private void initialize(File outputDirectory)
	{
		this.outputDirectory = outputDirectory;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Public functionality
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public void write(List<Symbol> symbols)
	{
		for(int i = 0;i < symbols.size();i++) {
			Symbol symbol = symbols.get(i);
			File packageDirectory = createPackage(outputDirectory, symbol, false);
			File outputSymbolFile = createSymbol(packageDirectory, symbol, true);
		}
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Private functionality
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	private File createPackage(File outputDirectory, Symbol symbol, boolean overwrite)
	{
		File curDirectory = outputDirectory;
		if(!curDirectory.exists()) {
			curDirectory.mkdirs();
		}

		String[] packageSplit = symbol.getPackage().split("\\.");
		for(int i = 0;i < packageSplit.length;i++) {
			curDirectory = new File(curDirectory.getAbsolutePath() + "\\" + packageSplit[i]);
			if(!curDirectory.exists()) {
				try {
					curDirectory.mkdir();
				} catch (Exception ignore) {}
			}
		}

		return curDirectory;
	}

	private File createSymbol(File packageDirectory, Symbol symbol, boolean overwrite)
	{
		VelocityContext context = new VelocityContext();
		VelocityEngine velocityEngine = initVelocity();
		setVelocityValues(context, symbol.getName(), symbol.getPackage(), symbol.getBitmapUrl(), symbol.getChildren());

		StringWriter writer = new StringWriter();
		velocityEngine.mergeTemplate((symbol.getType().equals(Symbol.BITMAP_TYPE)) ? VM_BITMAP_TEMPLATE : VM_SYMBOL_TEMPLATE, VM_ENCODING, context, writer);

		File symbolClassFile = new File(packageDirectory.getAbsoluteFile() + "\\" + symbol.getName() + ".java");
		if((!symbolClassFile.exists()) || ((symbolClassFile.exists()) && (overwrite))) {
			try {
				if(symbolClassFile.exists()) {
					symbolClassFile.delete();
				}
				symbolClassFile.createNewFile();

				PrintWriter out = new PrintWriter(symbolClassFile.getAbsoluteFile());
				out.println(writer.toString());
				out.close();

			} catch (IOException ignore) {}
		}

		return symbolClassFile;
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Private functionality (Velocity)
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	private VelocityEngine initVelocity()
	{
		Velocity.init();

		Properties properties = null;
		try {
			properties = new Properties();
			properties.load(getClass().getResourceAsStream(VM_PROPERTIES));
			return new VelocityEngine(properties);

		} catch (Exception e) {
			e.printStackTrace();
			return null;

		}
	}

	private void setVelocityValues(VelocityContext context, String symName, String symPackage, String bitmapUrl, Instance[] instances)
	{
		context.put("name", symName);
		context.put("package", symPackage);
		context.put("bitmapUrl", bitmapUrl);
		context.put("instances", Arrays.asList(instances));
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Getters & Setters
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//
}
