
package com.actionjava.mvn.plugins.assets.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.actionjava.mvn.plugins.assets.data.Parameter;
import com.actionjava.mvn.plugins.assets.data.instr.Arc;
import com.actionjava.mvn.plugins.assets.data.instr.ArcTo;
import com.actionjava.mvn.plugins.assets.data.instr.BeginBitmapFill;
import com.actionjava.mvn.plugins.assets.data.instr.BeginBitmapStroke;
import com.actionjava.mvn.plugins.assets.data.instr.BeginFill;
import com.actionjava.mvn.plugins.assets.data.instr.BeginLinearGradientFill;
import com.actionjava.mvn.plugins.assets.data.instr.BeginLinearGradientStroke;
import com.actionjava.mvn.plugins.assets.data.instr.BeginRadialGradientFill;
import com.actionjava.mvn.plugins.assets.data.instr.BeginRadialGradientStroke;
import com.actionjava.mvn.plugins.assets.data.instr.BeginStroke;
import com.actionjava.mvn.plugins.assets.data.instr.BezierCurveTo;
import com.actionjava.mvn.plugins.assets.data.instr.Clear;
import com.actionjava.mvn.plugins.assets.data.instr.ClosePath;
import com.actionjava.mvn.plugins.assets.data.instr.CurveTo;
import com.actionjava.mvn.plugins.assets.data.instr.DecodePath;
import com.actionjava.mvn.plugins.assets.data.instr.DrawCircle;
import com.actionjava.mvn.plugins.assets.data.instr.DrawEllipse;
import com.actionjava.mvn.plugins.assets.data.instr.DrawPolyStar;
import com.actionjava.mvn.plugins.assets.data.instr.DrawRect;
import com.actionjava.mvn.plugins.assets.data.instr.DrawRoundRect;
import com.actionjava.mvn.plugins.assets.data.instr.DrawRoundRectComplex;
import com.actionjava.mvn.plugins.assets.data.instr.EndFill;
import com.actionjava.mvn.plugins.assets.data.instr.EndStroke;
import com.actionjava.mvn.plugins.assets.data.instr.Instruction;
import com.actionjava.mvn.plugins.assets.data.instr.LineTo;
import com.actionjava.mvn.plugins.assets.data.instr.MoveTo;
import com.actionjava.mvn.plugins.assets.data.instr.QuadraticCurveTo;
import com.actionjava.mvn.plugins.assets.data.instr.Rect;
import com.actionjava.mvn.plugins.assets.data.instr.SetStrokeStyle;

public class GraphicsParser extends AbstractParser
{
	private static String REG_EX = "[a-zA-Z0-9_]+\\((.*(?![^\\[].*[^\\]]))\\)";
	private static String REG_E2 = "[a-zA-Z0-9_]+\\(.*(?![^\\[].*[^\\]])\\)";

	static {
		REG_EX = "";

		REG_EX += "[a-zA-Z0-9_]+";

		REG_EX += "\\(";

		REG_EX += "(";
		REG_EX += ".*";

		REG_EX += "(";
		REG_EX += "?!";
		REG_EX += "[^\\[]";
		REG_EX += ".*";
		REG_EX += "[^\\]]";
		REG_EX += ")";
		REG_EX += ")";
		REG_EX += "\\)";
	}

	private static final Map<String, Instruction> instrMapID;
	private static final Map<String, Instruction> instrMapName;

	static {
		instrMapID = new HashMap<String, Instruction>();
		instrMapName = new HashMap<String, Instruction>();

		Instruction inst = new Arc();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new ArcTo();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new BeginBitmapFill();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new BeginBitmapStroke();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new BeginFill();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new BeginLinearGradientFill();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new BeginLinearGradientStroke();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new BeginRadialGradientFill();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new BeginRadialGradientStroke();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new BeginStroke();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new BezierCurveTo();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new CurveTo();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new Clear();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new ClosePath();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new DecodePath();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new DrawCircle();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new DrawEllipse();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new DrawPolyStar();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new DrawRect();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new DrawRoundRect();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new DrawRoundRectComplex();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new EndFill();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new EndStroke();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new LineTo();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new MoveTo();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new QuadraticCurveTo();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new Rect();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);

		inst = new SetStrokeStyle();
		instrMapID.put(inst.getId(), inst);
		instrMapName.put(inst.getName(), inst);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public GraphicsParser()
	{
		super();
		initialize();
	}

	private void initialize()
	{
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Public functionality
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public Instruction[] parseGraphics(String lineRaw)
	{
		List<Instruction> instructions = new ArrayList<Instruction>();

		String[] tokens = lineRaw.split("\\)(?![^\\[]*\\])");
		for(String t:tokens) {
			String[] tokens2 = t.replaceAll("^[\\s\\.]+", "").split("\\((?![^\\[]*\\])");

			if(tokens2.length == 2) {
				String method = tokens2[0];
				Parameter[] params = parseParams(tokens2[1]);
				Instruction instr = getInstruction(method);
				if(instr != null) {
					try {
						instructions.add(instr.createNew(params));
					} catch (Exception e) {
						System.out.println("LENGTH=2 ERROR!!: " + e.getMessage() + " method: " + method);
					}
				}
			} else {
				String method = tokens2[0];
				Instruction instr = getInstruction(method);
				if(instr != null) {
					try {
						instructions.add(instr.createNew(null));
					} catch (Exception e) {
						System.out.println("LENGTH=1 ERROR!!: " + e.getMessage() + " method: " + method);
					}
				}
			}
		}

		return instructions.toArray(new Instruction[instructions.size()]);
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Private functionality
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	private Instruction getInstruction(String method)
	{
		Instruction instr = getInstructionByID(method);
		if(instr == null) {
			instr = getInstructionByName(method);
		}

		return instr;
	}

	private Instruction getInstructionByID(String methodID)
	{
		if(instrMapID.containsKey(methodID)) { return instrMapID.get(methodID); }
		return null;
	}

	private Instruction getInstructionByName(String methodName)
	{
		if(instrMapName.containsKey(methodName)) { return instrMapName.get(methodName); }
		return null;
	}
}
