
package com.actionjava.mvn.plugins.assets.parsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import com.actionjava.mvn.plugins.assets.data.Instance;
import com.actionjava.mvn.plugins.assets.data.Parameter;
import com.actionjava.mvn.plugins.assets.data.Shape;
import com.actionjava.mvn.plugins.assets.data.Sprite;
import com.actionjava.mvn.plugins.assets.data.Symbol;
import com.actionjava.mvn.plugins.assets.data.instr.Instruction;
import com.actionjava.mvn.plugins.assets.vo.Transform;

public abstract class InstanceParser extends AbstractParser
{
	private static final String INSTANCE_NAME = "this.([a-zA-Z0-9_]+)\\s=\\snew";
	private static final String INSTANCE_CJS = "this.([a-zA-Z0-9_]+)\\s=\\snew cjs";
	private static final String INSTANCE_LIB = "this.([a-zA-Z0-9_]+)\\s=\\snew lib\\.(.*)\\(\\);$";
	private static final String INSTANCE_GRAPHICS = "this.([a-zA-Z0-9_]+).graphics";
	private static final String INSTANCE_TRANSFORM = "this.([a-zA-Z0-9_]+).setTransform";

	private GraphicsParser graphicsParser;
	private TransformParser transformParser;

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Constructor & initialize
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public InstanceParser()
	{
		super();
		initialize();
	}

	private void initialize()
	{
		this.graphicsParser = new GraphicsParser();
		this.transformParser = new TransformParser();
	}

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Public functionality
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	public Instance parseInstance(String[] lines)
	{
		String nameRaw = null;
		String graphicsRaw = null;
		String transformRaw = null;

		String name = null;
		Instance instance = null;
		Transform transform = null;
		Instruction[] graphics = null;

		int lineID;
		String line;
		for(int i = 0;i < lines.length;i++) {
			line = lines[i];
			lineID = identifyLine(line);

			switch (lineID) {
				case 1:
					nameRaw = line;
					break;
				case 2:
					graphicsRaw = line;
					break;
				case 3:
					transformRaw = line;
					break;
				default:
					break;
			}
		}

		if(nameRaw != null) {
			name = parseName(nameRaw);

			if(graphicsRaw == null) {
				instance = new Sprite(name, name, getSymbolByName(parseClassName(nameRaw)));
			} else {
				instance = new Shape(name, name);
			}

			if(transformRaw != null) {
				instance.setTransform(Transform.createNew(parseTransform(transformRaw)));
			}

			if(graphicsRaw != null) {
				graphics = parseGraphics(graphicsRaw);
				((Shape) instance).setGraphics(graphics);
			}

			return instance;
		}

		return null;
	}

	public abstract Symbol getSymbolByName(String name);

	//
	//
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	// - - Private functionality
	// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	//
	//

	private int identifyLine(String line)
	{
		Pattern pattern = Pattern.compile(INSTANCE_NAME, Pattern.DOTALL);
		Matcher matcher = pattern.matcher(line);
		if(matcher.find()) { return 1; }

		pattern = Pattern.compile(INSTANCE_GRAPHICS, Pattern.DOTALL);
		matcher = pattern.matcher(line);
		if(matcher.find()) { return 2; }

		pattern = Pattern.compile(INSTANCE_TRANSFORM, Pattern.DOTALL);
		matcher = pattern.matcher(line);
		if(matcher.find()) { return 3; }

		return 0;
	}

	private String parseName(String lineRaw)
	{
		Pattern pattern = Pattern.compile(INSTANCE_NAME, Pattern.DOTALL);
		Matcher matcher = pattern.matcher(lineRaw);
		if(matcher.find()) { return matcher.group(1); }

		return null;
	}

	private String parseClassName(String lineRaw)
	{
		Pattern pattern = Pattern.compile(INSTANCE_LIB, Pattern.DOTALL);
		Matcher matcher = pattern.matcher(lineRaw);
		if(matcher.find()) {
			String s1 = matcher.group(2);
			return s1.substring(0, 1).toUpperCase() + s1.substring(1);
		}

		return null;
	}

	private Instruction[] parseGraphics(String lineRaw)
	{
		Pattern pattern = Pattern.compile(INSTANCE_GRAPHICS, Pattern.DOTALL);
		Matcher matcher = pattern.matcher(lineRaw);

		if(matcher.find()) {
			return graphicsParser.parseGraphics(lineRaw.replaceAll("^.*this.[a-zA-Z0-9_]+.graphics.", ""));

		} else {
			System.out.println("ERROR, THIS IS NOT A GRAPHICS LINE!!");

		}

		return null;
	}

	private Parameter[] parseTransform(String lineRaw)
	{
		Pattern pattern = Pattern.compile(INSTANCE_TRANSFORM, Pattern.DOTALL);
		Matcher matcher = pattern.matcher(lineRaw);

		if(matcher.find()) {
			return transformParser.parseTransform(lineRaw);

		} else {
			System.out.println("ERROR, THIS IS NOT A TRANSFORM LINE!!");

		}

		return null;
	}
}
