
package com.actionjava.mvn.plugins.assets.vo;

import com.actionjava.mvn.plugins.assets.data.Parameter;

public class Transform
{
	private double x;
	private double y;
	private double scaleX;
	private double scaleY;
	private double rotation;
	private double skewX;
	private double skewY;
	private double regX;
	private double regY;

	public Transform(double x, double y, double scaleX, double scaleY, double rotation, double skewX, double skewY, double regX, double regY)
	{
		super();
		initialize(x, y, scaleX, scaleY, rotation, skewX, skewY, regX, regY);
	}

	private void initialize(double x, double y, double scaleX, double scaleY, double rotation, double skewX, double skewY, double regX, double regY)
	{
		this.x = x;
		this.y = y;
		this.scaleX = scaleX;
		this.scaleY = scaleY;
		this.rotation = rotation;
		this.skewX = skewX;
		this.skewY = skewY;
		this.regX = regX;
		this.regY = regY;
	}

	public double getX()
	{
		return x;
	}

	public void setX(double x)
	{
		this.x = x;
	}

	public double getY()
	{
		return y;
	}

	public void setY(double y)
	{
		this.y = y;
	}

	public double getScaleX()
	{
		return scaleX;
	}

	public void setScaleX(double scaleX)
	{
		this.scaleX = scaleX;
	}

	public double getScaleY()
	{
		return scaleY;
	}

	public void setScaleY(double scaleY)
	{
		this.scaleY = scaleY;
	}

	public double getRotation()
	{
		return rotation;
	}

	public void setRotation(double rotation)
	{
		this.rotation = rotation;
	}

	public double getSkewX()
	{
		return skewX;
	}

	public void setSkewX(double skewX)
	{
		this.skewX = skewX;
	}

	public double getSkewY()
	{
		return skewY;
	}

	public void setSkewY(double skewY)
	{
		this.skewY = skewY;
	}

	public double getRegX()
	{
		return regX;
	}

	public void setRegX(double regX)
	{
		this.regX = regX;
	}

	public double getRegY()
	{
		return regY;
	}

	public void setRegY(double regY)
	{
		this.regY = regY;
	}

	public static Transform createNew(Parameter[] params)
	{
		if(params.length == 0) {
			return new Transform(0, 0, 1, 1, 0, 0, 0, 0, 0);

		} else if(params.length == 1) {
			return new Transform(params[0].getNumberValue(), 0, 1, 1, 0, 0, 0, 0, 0);

		} else if(params.length == 2) {
			return new Transform(params[0].getNumberValue(), params[1].getNumberValue(), 1, 1, 0, 0, 0, 0, 0);

		} else if(params.length == 3) {
			return new Transform(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), 1, 0, 0, 0, 0, 0);

		} else if(params.length == 4) {
			return new Transform(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), 0, 0, 0, 0, 0);

		} else if(params.length == 5) {
			return new Transform(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), params[4].getNumberValue(), 0, 0, 0, 0);

		} else if(params.length == 6) {
			return new Transform(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), params[4].getNumberValue(), params[5].getNumberValue(), 0, 0, 0);

		} else if(params.length == 7) {
			return new Transform(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), params[4].getNumberValue(), params[5].getNumberValue(), params[6].getNumberValue(), 0, 0);

		} else if(params.length == 8) {
			return new Transform(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), params[4].getNumberValue(), params[5].getNumberValue(), params[6].getNumberValue(), params[7].getNumberValue(), 0);

		} else if(params.length == 9) { return new Transform(params[0].getNumberValue(), params[1].getNumberValue(), params[2].getNumberValue(), params[3].getNumberValue(), params[4].getNumberValue(), params[5].getNumberValue(), params[6].getNumberValue(), params[7].getNumberValue(), params[8].getNumberValue());

		}

		return null;
	}
}
