package com.ats.executor.drivers;

import java.net.URI;

import com.ats.executor.channels.Channel;
import com.ats.tools.logger.ExecutionLogger;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class DriverInfoDesktop implements IDriverInfo {

	private final String DESKTOP_EXPLORER_SESSION = "explorer-session";
	private final String DESKTOP_APP_SESSION = "app-session";

	protected String name;

	private String session = "no-session";

	public DriverInfoDesktop(String name, String type) {
		this.name = name;
		if(Channel.DESKTOP.equals(type)) {
			this.session = DESKTOP_APP_SESSION;
		}else if(Channel.DESKTOP_EXPLORER.equals(type)) {
			this.session = DESKTOP_EXPLORER_SESSION;
		}
	}

	@Override
	public String getDriverVersion() {
		return "";
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public String getId() {
		return "";
	}

	@Override
	public void setSessionId(String string) {
	}

	@Override
	public String getSessionId() { return session; }

	@Override
	public StringBuilder getDriverSessionUrl() {
		return new StringBuilder();
	}

	@Override
	public URI getDriverServerUri() {
		return null;
	}

	@Override
	public URI getDriverLoopback() {
		return null;
	}

	@Override
	public String getApplicationPath() {
		return "";
	}

	@Override
	public StringBuilder getDriverHostAndPort() {
		return new StringBuilder();
	}

	@Override
	public boolean isAlive() {
		return true;
	}

	@Override
	public void close() {
	}

	@Override
	public void quit() {
	}

	@Override
	public void setUdpInfo(String info) {
	}

	@Override
	public String getScreenshotUrl() {
		return "";
	}

	@Override
	public void setHeadless(boolean value) {
	}

	@Override
	public boolean isHeadless() {
		return false;
	}

	@Override
	public JsonNode toJson() {
		final ObjectNode data = new ObjectMapper().createObjectNode();
		data.put(DriverInfo.SESSION_ID, "");
		data.put("name", name);
		data.put("screenshotUrl", "");
		data.put("headless", false);

		final ObjectNode node = new ObjectMapper().createObjectNode();
		node.set(DriverInfo.DRIVER_INFO, data);

		return node;
	}

	@Override
	public void sendLogsInfo(ExecutionLogger logger) {
	}

	@Override
	public String getUuid() {
		return "";
	}
}