package com.ats.executor.drivers.engines.mobiles;

import java.util.ArrayList;

import javax.annotation.Nonnull;

import com.ats.element.AtsMobileElement;
import com.ats.element.FoundElement;
import com.ats.element.MobileTestElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.SendKeyData;
import com.ats.executor.drivers.engines.MobileDriverEngine;
import com.ats.generator.objects.MouseDirection;
import com.fasterxml.jackson.databind.JsonNode;

public abstract class RootElement {

	protected AtsMobileElement value;
	protected MobileDriverEngine driver;

	public RootElement(MobileDriverEngine driver) {
		this.driver = driver;
	}

	public AtsMobileElement getValue() {
		return value;
	}

	abstract public void refresh(@Nonnull JsonNode node);
	abstract public void tap(ActionStatus status, FoundElement element, MouseDirection position);
	abstract public void tap(FoundElement element, int count);
	abstract public void press(FoundElement element, ArrayList<String> paths, int duration);
	abstract public void swipe(MobileTestElement testElement, int hDirection, int vDirection);
	abstract public void textInput(TestElement element, ArrayList<SendKeyData> textActionList);
	abstract public void clearInput(TestElement element);
	abstract public Object scripting(String script, FoundElement element);
	abstract public Object scripting(String script);
	abstract public MobileTestElement getCurrentElement(FoundElement element, MouseDirection position);
}