/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
 */

package com.ats.executor.gobblers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import com.ats.executor.drivers.DriverInfoLocal;

public class StreamGobblerInput extends StreamGobbler
{

	public StreamGobblerInput(InputStream is, DriverInfoLocal dp) {
		super(is, dp);
	}

	@Override
	public void run()
	{
		try
		{
			final InputStreamReader isr = new InputStreamReader(inputStream);
			final BufferedReader br = new BufferedReader(isr);
			String line = null;
			while ((line = br.readLine()) != null) {
				synchronized(driverProcess){
					driverProcess.output(line);
				}
			}
			br.close();

			if (inputStream instanceof BufferedInputStream) {
				synchronized(driverProcess){
					try {
						if(inputStream.available() > 0) {
							driverProcess.unExpectedExit();
						}
					}catch(Exception e) {}
				}
			}

			isr.close();

			terminate();

		} catch (IOException ioe)
		{
			ioe.printStackTrace();
		}
	}
}