/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
*/

package com.ats.generator;

import java.util.ArrayList;
import java.util.Date;

public class GeneratorReport {

	private int generatedScriptsCount = -1;
	private long generationEllapsedTime = -1;

	private ArrayList<String> errorLogs;

	public GeneratorReport() {
		errorLogs = new ArrayList<>();
	}

	public void addError(String message){
		errorLogs.add(message);
	}

	public void startGenerator(int count){
		generatedScriptsCount = count;
		generationEllapsedTime = new Date().getTime();
	}

	public void endGenerator(){
		generationEllapsedTime = new Date().getTime() - generationEllapsedTime;
	}

	public int getGeneratedScriptsCount() {
		return generatedScriptsCount;
	}

	public long getGenerationEllapsedTime() {
		return generationEllapsedTime;
	}
}