/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
 */

package com.ats.generator.variables.transform.code;

import com.ats.generator.variables.transform.EvalTransformer;

public class JavaScriptCodeEval  extends CodeEval{
		
	private static String jsfy(String code) {
		
		code = code.replace("\"", "'");
		if(code.endsWith(";")) {
			code = code.substring(0, code.length()-1);
		}
		
		return String.format(
				"print(%s)",
				code);
	}

	public JavaScriptCodeEval(String code) {
		super(EvalTransformer.JS, jsfy(code));
	}
}