/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
*/

package com.ats.script.actions;

import java.util.ArrayList;
import java.util.function.Predicate;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.script.Script;
import com.ats.script.actions.condition.ExecuteOptions;

public class ActionGestureTap extends ActionExecuteElement {

	public static final String SCRIPT_LABEL = "tap";
	public static final Predicate<String> PREDICATE = g -> SCRIPT_LABEL.equals(g);

	private int count;

	//---------------------------------------------------------------------------------------------------------------------------------
	// Constructors
	//---------------------------------------------------------------------------------------------------------------------------------

	public ActionGestureTap(Script script, ExecuteOptions options, String count, int stopPolicy, ArrayList<String> element) {
		super(script, options, stopPolicy, element);
		setCount(Integer.parseInt(count));
	}

	public ActionGestureTap(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, int count) {
		super(script, options, stopPolicy, maxTry, delay, element);
		setCount(count);
	}

	//---------------------------------------------------------------------------------------------------------------------------------
	//---------------------------------------------------------------------------------------------------------------------------------

	@Override
	public void terminateExecution(ActionTestScript ts) {
		super.terminateExecution(ts);

		if (status.isPassed()) {
			ts.getRecorder().updateScreen(true);

			getTestElement().tap(count);

			status.endAction();
			ts.getRecorder().updateScreen(status);
		}
	}

	//---------------------------------------------------------------------------------------------------------------------------------
	// Code Generator
	//---------------------------------------------------------------------------------------------------------------------------------

	@Override
	public StringBuilder getJavaCode() {
		StringBuilder codeBuilder = super.getJavaCode();
		codeBuilder.append(", ") .append(count).append(")");
		return codeBuilder;
	}

	//--------------------------------------------------------
	// getters and setters for serialization
	//--------------------------------------------------------

	public int getCount() { return count; }
	public void setCount(int count) { this.count = count; }
}
