package com.ats.tools.report.analytics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.category.DefaultCategoryDataset;

public class ActionsType {

	private static final Color GRID_COLOR = Color.decode("#5a6886");
	private static final Color TRANSPARENT_COLOR = new Color(0x00, 0x00, 0x00, 0);

	private static final Color NAVIGATION_COLOR = Color.decode("#1BBC9B");
	private static final Color SUBSCRIPT_COLOR = Color.decode("#3498DB");
	private static final Color USER_ACTION_COLOR = Color.decode("#72B500");
	private static final Color ASSERT_COLOR = Color.decode("#EE6AB9");
	private static final Color TECHNICAL_COLOR = Color.decode("#6E4AD3");
	private static final Color OTHER_COLOR = Color.decode("#7D7D7D");

	private DefaultCategoryDataset dataSet;
	private int navigationCount = 0;
	private int callScriptCount = 0;
	private int userActionCount = 0;
	private int assertCount = 0;
	private int technicalCount = 0;
	private int others = 0;

	public ActionsType() {
		dataSet = new DefaultCategoryDataset();
	}

	public ActionsType(int mouseCount, int textCount, int assertCount, int otherCount) {

	}

	public void addActionType(String type) {
		switch (ActionTypesEnum.of(type)) {
			case NAVIGATION: {
				navigationCount++;
				break;
			}
			case CALL_SCRIPT: {
				callScriptCount++;
				break;
			}
			case USER_ACTION: {
				userActionCount++;
				break;
			}
			case ASSERT: {
				assertCount++;
				break;

			}
			case TECHNICAL: {
				technicalCount++;
				break;
			}
			case SSA: {
				break;
			}
			default:
				others++;
				break;
		}
	}

	public String getBase64Chart() {
		dataSet.addValue(navigationCount, "Navigation", "s1");
		dataSet.addValue(callScriptCount, "Callscript", "s1");
		dataSet.addValue(userActionCount, "User action", "s1");
		dataSet.addValue(assertCount, "Assertion", "s1");
		dataSet.addValue(technicalCount, "Technical", "s1");
		dataSet.addValue(others, "Others", "s1");

		JFreeChart chart = ChartFactory.createBarChart(
				null,
				null, null,
				dataSet, PlotOrientation.VERTICAL,
				true, true, false);

		final CategoryPlot plot = chart.getCategoryPlot();

		BarRenderer renderer = (BarRenderer) plot.getRenderer();

		renderer.setSeriesPaint(0, NAVIGATION_COLOR);
		renderer.setSeriesPaint(1, SUBSCRIPT_COLOR);
		renderer.setSeriesPaint(2, USER_ACTION_COLOR);
		renderer.setSeriesPaint(3, ASSERT_COLOR);
		renderer.setSeriesPaint(4, TECHNICAL_COLOR);
		renderer.setSeriesPaint(5, OTHER_COLOR);

		renderer.setBarPainter(new StandardBarPainter());
		renderer.setShadowVisible(false);

		chart.getLegend().setPosition(RectangleEdge.RIGHT);

		chart.getLegend().setBackgroundPaint(TRANSPARENT_COLOR);

		plot.getDomainAxis().setVisible(false);
		plot.getDomainAxis().setTickLabelsVisible(false);
		plot.getRangeAxis().setVisible(false);
		plot.getRangeAxis().setTickLabelsVisible(false);
		plot.setOutlinePaint(null);

		float[] dash1 = {1f, 0f, 2f};

		plot.setRangeGridlineStroke(new BasicStroke(0.3F, BasicStroke.CAP_BUTT, BasicStroke.JOIN_ROUND, 1.0f, dash1, 2f));
		plot.setRangeGridlinePaint(GRID_COLOR);

		chart.setBackgroundPaint(TRANSPARENT_COLOR);
		plot.setBackgroundPaint(TRANSPARENT_COLOR);

		NumberAxis range = (NumberAxis) plot.getRangeAxis();
		range.setTickUnit(new NumberTickUnit(2));

		final ChartPanel chartPanel = new ChartPanel(chart);
		chartPanel.setPreferredSize(new java.awt.Dimension(230, 120));

		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		try {
			ChartUtils.writeChartAsPNG(baos, chart, 230, 120);
		} catch (IOException e) {
			return null;
		}

		return Base64.getEncoder().encodeToString(baos.toByteArray());
	}
}