package com.ats.tools.report.analytics;

import java.awt.Color;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.Iterator;

import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.chart.util.UnitType;
import org.jfree.data.general.PieDataset;

import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;


@SuppressWarnings({ "unchecked", "rawtypes", "serial" })
public class AtsPieChart implements JRChartCustomizer {

	private static final String FAIL = "fail";
	private static final String PASS = "pass";
	private static final String SKIP = "skip";
	private static final String EMPTY = "empty";

	private static final Color FAIL_COLOR = Color.decode("#35535E");
	private static final Color PASS_COLOR = Color.decode("#9CBF3F");
	private static final Color SKIP_COLOR = Color.decode("#ECF0DF");
	private static final Color EMPTY_COLOR = Color.decode("#d4d0d8");
	
	private static StandardPieSectionLabelGenerator labelGen = new StandardPieSectionLabelGenerator("{0} ({2})", new DecimalFormat("0"), new DecimalFormat("0%")) {
		@Override
		public String generateSectionLabel(PieDataset dataset, Comparable key) {
			if(dataset.getValue(key).intValue() == 0) {
				return null;
			}
			return super.generateSectionLabel(dataset, key);
		}
	};

	@Override
	public void customize(JFreeChart chart, JRChart jasperChart) {

		PiePlot<String> plot = (PiePlot<String>) chart.getPlot();
		plot.setLabelBackgroundPaint(null);
		plot.setLabelOutlinePaint(null);
		plot.setLabelShadowPaint(null);
		plot.setShadowXOffset(0.0D);
		plot.setShadowYOffset(0.0D);
		plot.setOutlineVisible(false);
		plot.setSimpleLabels(false);
		plot.setOutlinePaint(Color.WHITE);
		plot.setStartAngle(90);
		plot.setInteriorGap(0);
		plot.setDefaultSectionOutlinePaint(Color.WHITE);

		plot.setMaximumLabelWidth(0.2D);
		plot.setInsets(new RectangleInsets(UnitType.ABSOLUTE, 0.0D, 0.0D, 1.0D, 1.0D));
		plot.setLegendItemShape(new Rectangle.Double(1.0D, 2.0D, 30.0D, 6.0D));

		PieDataset<String> dataSet = plot.getDataset();

		Iterator<LegendItem> iterator = plot.getLegendItems().iterator();
		while(iterator.hasNext()){
			LegendItem item = iterator.next();
			if(dataSet.getValue(item.getSeriesIndex()).intValue() == 0) {
				iterator.remove();
			}
		}

		plot.setLabelGenerator(labelGen);
		plot.setSectionPaint(FAIL, FAIL_COLOR);
		plot.setSectionPaint(PASS, PASS_COLOR);
		plot.setSectionPaint(SKIP, SKIP_COLOR);
		plot.setSectionPaint(EMPTY, EMPTY_COLOR);

		/*for (int i = 0; i < dataSet.getItemCount(); i++) {
            if(FAIL.equals(dataSet.getKey(i))){
                plot.setSectionPaint(FAIL, FAIL_COLOR);
            }else if(PASS.equals(dataSet.getKey(i))){
                plot.setSectionPaint(PASS, PASS_COLOR);
            }else if(SKIP.equals(dataSet.getKey(i))){
                plot.setSectionPaint(SKIP, SKIP_COLOR);
            }
        }*/

		plot.setShadowGenerator(null);
	}
}