package com.ats.tools.report.utils;

import com.ats.tools.Utils;
import com.ats.tools.logger.levels.AtsLogger;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

import static com.ats.tools.report.utils.FileUtils.copyResource;

public class JasperSummaryUtils {

    public static void generateSummaryPdf(Path outputFolderPath, String dataFileName) {
        processJasperTemplates(outputFolderPath);
        processSummaryPdf(outputFolderPath, dataFileName);
    }

    private static void processJasperTemplates(Path outputFolderPath) {

        final Path outputJasperFolder = outputFolderPath.resolve("ats-jasper");
        try {
            Utils.deleteRecursive(outputJasperFolder.toFile());
        } catch (FileNotFoundException e) {
        }

        try {
            Files.createDirectory(outputJasperFolder);
        } catch (IOException e) {
            e.printStackTrace();
        }

        copyResource("suite.jrxml", outputJasperFolder);
        copyResource("test.jrxml", outputJasperFolder);
        copyResource("summary.jrxml", outputJasperFolder);

        try {
            JasperCompileManager.compileReportToFile(outputJasperFolder.resolve("test.jrxml").toString(), outputJasperFolder.resolve("test.jasper").toString());
            JasperCompileManager.compileReportToFile(outputJasperFolder.resolve("suite.jrxml").toString(), outputJasperFolder.resolve("suite.jasper").toString());
            JasperCompileManager.compileReportToFile(outputJasperFolder.resolve("summary.jrxml").toString(), outputJasperFolder.resolve("summary.jasper").toString());
       
            AtsLogger.printLog("JASPER reports templates generated");
            
        } catch (JRException e) {
            AtsLogger.printLog("error generating jasper files -> " + e.getMessage());
        }
    }

    private static void processSummaryPdf(Path outputFolderPath, String dataFileName) {
        try {
            final String reportFullName = outputFolderPath.resolve("summary.pdf").toString();
            final Path outputJasperFolder = outputFolderPath.resolve("ats-jasper");

            final Map<String, Object> parameters = new HashMap<>();
            parameters.put("workingDir", outputJasperFolder.toString());
            parameters.put("xmlSource", outputFolderPath.resolve(dataFileName).toString());
            parameters.put("xmlSourceRoot", "ats-report");

            String fileName = JasperFillManager.fillReportToFile(outputJasperFolder.resolve("summary.jasper").toString(), parameters);

            JasperExportManager.exportReportToPdfFile(fileName, reportFullName);

            AtsLogger.printLog("PDF file -> " + reportFullName + " ... OK");
        } catch (JRException e) {
            e.printStackTrace();
        }
    }

}
