package com.ats.tools.report.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;

import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

import org.w3c.dom.Element;

import com.ats.executor.TestBound;
import com.ats.recorder.VisualElement;
import com.ats.tools.Utils;
import com.luciad.imageio.webp.WebPWriteParam;

public class ReportImageWebpFormat implements IReportImageFormat {

	private WebPWriteParam writeParam;
	private ImageWriter writer;
	
	public ReportImageWebpFormat() {
		
		//writer = ImageIO.getImageWritersByMIMEType("image/webp").next();
		writer = ImageIO.getImageWritersByFormatName("webp").next();
		
		writeParam = new WebPWriteParam(writer.getLocale());
		writeParam.setCompressionMode(ImageWriteParam.MODE_EXPLICIT);
		writeParam.setCompressionType(writeParam.getCompressionTypes()[WebPWriteParam.LOSSY_COMPRESSION]);
	}

	@Override
	public void format(Element img, boolean isError, String imageType, ArrayList<byte[]> images, VisualElement element, int ref) {
		img.setAttribute("type", "webp");
		img.setAttribute("src", getWebpImageData(isError, imageType, images, element, ref));
	}
	
	private String getWebpImageData(boolean isError, String imgType, ArrayList<byte[]> images, VisualElement element, int ref) {

		if (images.size() > 0 && images.get(0) != null) {
			if (element != null && element.getRectangle() != null) {
				int imageRef = 0;
				if (isError && images.size() > 0) {
					imageRef = images.size() - 1;
				} else if (images.size() > ref) {
					imageRef = ref;
				}

				final TestBound bound = element.getRectangle();

				try {

					final BufferedImage image = ImageIO.read(new ByteArrayInputStream(images.get(imageRef)));

					final Graphics2D g1 = image.createGraphics();
					g1.setColor(new Color(255, 0, 255));
					g1.setStroke(new BasicStroke(3));
					g1.drawRect(bound.getX().intValue(), bound.getY().intValue() - 10, bound.getWidth().intValue(), bound.getHeight().intValue());
					g1.dispose();

					final ByteArrayOutputStream baos = new ByteArrayOutputStream();
					final ImageOutputStream ios = ImageIO.createImageOutputStream(baos);

					writer.setOutput(ios);
					writer.write(null, new IIOImage(image, null, null), writeParam);
					ios.flush();
					ios.close();

					return Base64.getEncoder().encodeToString(baos.toByteArray());

				} catch (IOException e) {}

			} else {
				return Base64.getEncoder().encodeToString(images.get(images.size() - 1));
			}
		}

		return Utils.EMPTY_SCREEN;
	}
}
