document.addEventListener('DOMContentLoaded', function () {
    window.addEventListener('scroll', updateCurrentSection);
});

let isPopupOpened = false;
let isPlaylistNameInWidgetTruncated = false;

function processWidowResize() {
    let minimalWindowWidth = 1858;
    let startLeftPosition = 1608;
    let fixedDiv = document.getElementsByClassName('navigation-widget-container')[0];
    let windowWidth = window.innerWidth;

    if (fixedDiv) {
        if (windowWidth < minimalWindowWidth) {
            fixedDiv.style.left = `${startLeftPosition - (minimalWindowWidth - windowWidth + 35)}px`;
        } else {
            fixedDiv.style.left = 'calc(50% + 650px)';
        }
    }

    if (!isPopupOpened) {
        toggleNavigationWidget(false);
    }
}

processWidowResize();
window.addEventListener('resize', processWidowResize);

function updateCurrentSection() {
    const playlistSections = Array.from(document.querySelectorAll('.playlist'));
    const sections = Array.from(document.querySelectorAll('.general-layout'));
    const navWidget = document.getElementsByClassName('navigation-widget-header')[0];
    const currentSection = document.getElementById('current-section');
    const currentSectionHeader = document.querySelector('.current-section-header');

    function isElementOverlapping(el1, el2) {
        const rect1 = el1.getBoundingClientRect();
        const rect2 = el2.getBoundingClientRect();
        return !(rect1.top > rect2.bottom || rect1.right < rect2.left || rect1.bottom < rect2.top || rect1.left > rect2.right);
    }

    let overlappingSectionId = 'None';
    sections.forEach(section => {
            if (isElementOverlapping(navWidget, section)) {
                overlappingSectionId = section.id;
            }
        }
    );
    let overlappingPlaylistId = 'None';
    playlistSections.forEach(section => {
            if (isElementOverlapping(navWidget, section)) {
                overlappingPlaylistId = section.childNodes[5].id.replace('-suite-data', '');
            }
        }
    );
    let headerNameNodes = navWidget.childNodes[3].childNodes;
    if (headerNameNodes[1]) {
        headerNameNodes[1].textContent = overlappingPlaylistId;
    }
    navWidget.childNodes[3].title = overlappingPlaylistId;

    headerNameNodes[1].classList.remove('truncated-text-140');

    if (!headerNameNodes[1].classList.contains('truncated-text-140')) {
        if (headerNameNodes[1].clientWidth > 140) {
            headerNameNodes[1].classList.add('truncated-text-140');
        }
    }

    let currentSectionNameArray = overlappingSectionId.split(".");
    if (currentSectionNameArray.length > 1) {
        currentSectionHeader.textContent = overlappingSectionId.replace('.' + currentSectionNameArray[currentSectionNameArray.length - 1], "");
    } else {
        currentSectionHeader.textContent = '';
    }
    currentSection.textContent = currentSectionNameArray[currentSectionNameArray.length - 1].split(' ')[0];
    currentSectionHeader.style.width = '';
    if (currentSectionHeader.clientWidth > 132) {
        if (currentSection.clientWidth > 132) {
            currentSectionHeader.style.width = currentSection.clientWidth + 'px';
        } else {
            currentSectionHeader.style.width = '132px';
        }
    }
    let containerWidth = currentSection.parentElement.parentElement.parentElement.parentElement.clientWidth;
    if (containerWidth > 288) {
        let leftPosition = 650 - (containerWidth - 288);
        currentSection.parentElement.parentElement.parentElement.parentElement.style.left = 'calc(50% + ' + leftPosition + 'px)';
    } else {
        currentSection.parentElement.parentElement.parentElement.parentElement.style.left = 'calc(50% + 650px)';
    }
    currentSectionHeader.title = currentSectionNameArray;
    currentSection.title = overlappingSectionId;
}


function applyVerticalStyle(imageSrc, imageModal, isRemove) {
    if (isRemove) {
        if (imageSrc.includes('video')) {
            imageModal.childNodes[3].classList.remove('image-vertical');
        } else {
            imageModal.childNodes[1].classList.remove('image-vertical');
        }
    } else {
        if (imageSrc.includes('video')) {
            imageModal.childNodes[3].classList.add('image-vertical');
        } else {
            imageModal.childNodes[1].classList.add('image-vertical');
        }
    }
}

function openImageModal(dataImageHost) {
    isPopupOpened = true;
    document.body.classList.add('noscroll');
    toggleNavigationWidget(true);
    let imageSrc = dataImageHost.childNodes[0].src;
    let imageModal = document.getElementById('imageModal');

    if (imageSrc.includes('video')) {
        imageModal.childNodes[3].src = imageSrc;
        imageModal.childNodes[3].style.display = 'block';
        imageModal.childNodes[1].style.display = 'none';
    } else {
        imageModal.childNodes[1].src = imageSrc;
        imageModal.childNodes[3].style.display = 'none';
        imageModal.childNodes[1].style.display = 'block';
    }

    let contentHeight = document.getElementsByClassName('image-modal-content')[0].height;
    let innerHeight = window.innerHeight;
    imageModal.style.display = 'flex';

    if (contentHeight > innerHeight) {
        imageModal.classList.add('image-vertical');
        applyVerticalStyle(imageSrc, imageModal, false);
    } else {
        imageModal.classList.remove('image-vertical');
        applyVerticalStyle(imageSrc, imageModal, true)
    }

}

function closeImageModal() {
    isPopupOpened = false;
    document.body.classList.remove('noscroll');
    toggleNavigationWidget(true);
    let imageModal = document.getElementById('imageModal');
    imageModal.style.display = 'none';
}

function toggleElement(elementId, switchElement, type) {
    let element = document.getElementById(elementId);
    let baseClassName;

    if (type === 'actions') {
        baseClassName = 'actions-container';
    } else if (type === 'testCase') {
        baseClassName = 'test-case-body';
    } else if (type === 'suite') {
        baseClassName = 'playlist-data-general'
    } else if (type === 'errors-group') {
        baseClassName = 'non-blocking-errors-items';
    } else {
        console.error('Unknown type:', type);
        return;
    }

    element.className = element.className === `${baseClassName} collapsed` ? baseClassName : `${baseClassName} collapsed`;
    switchElement.className = switchElement.className === 'display-toggle-icon-right' ? 'display-toggle-icon-down' : 'display-toggle-icon-right';
    if (!isPopupOpened) {
        toggleNavigationWidget(false);
    }
}

function toggleActionsView(toggleButton) {
    toggleButton.parentElement.childNodes[1].click();
}

function toggleCollapsedElementsWithNavigationWidget(elementId) {
    let testCaseElement = document.getElementById(elementId);
    let actionsSectionElement = document.getElementById(elementId.replace('test-data', 'actions-container'));

    let suiteElement = testCaseElement.parentElement.parentElement.parentElement.parentElement.parentElement;
    Array.from(suiteElement.getElementsByClassName('test-case-body')).forEach(el => el.classList.add('collapsed'));
    Array.from(suiteElement.getElementsByClassName('display-toggle-icon-down')).forEach(el => el.className = 'display-toggle-icon-right');

    Array.from(testCaseElement.parentElement.getElementsByClassName('display-toggle-icon-right')).forEach(el => el.className = 'display-toggle-icon-down');

    testCaseElement.className = 'test-case-body';
    actionsSectionElement.className = 'actions-container';
}

function toggleNavigationWidget(isAbsoluteToggle) {
    const viewportHeight = window.innerHeight;
    const pageHeight = document.documentElement.scrollHeight;

    const heightDifference = pageHeight - viewportHeight;

    let navigationWidget = document.getElementsByClassName("navigation-widget-container")[0];

    if (navigationWidget) {
        if (isAbsoluteToggle) {
            if (heightDifference > 50) {
                navigationWidget.className = navigationWidget.className === 'navigation-widget-container' ? 'navigation-widget-container collapsed' : 'navigation-widget-container';
                return;
            }
        }

        if (heightDifference > 50) {
            navigationWidget.className = 'navigation-widget-container';
            updateCurrentSection();
        } else {
            navigationWidget.className = 'navigation-widget-container collapsed';
        }
    }
}

function applyTruncationToScriptNamesInAction() {
    document.querySelectorAll('.script-name-text').forEach(element => {
        if (element.parentElement.parentElement.parentElement.parentElement.classList.contains("status-line-non-functional")) {
            if (element.clientWidth > 1210) {
                element.classList.add('truncated-text-1210');
            }
        } else {
            if (element.clientWidth > 790) {
                element.classList.add('truncated-text-790');
            }
        }
    });
}

function applyTruncationToSuiteName() {
    document.querySelectorAll('.playlist-info-name-text').forEach(element => {
        if (element.clientWidth > 460) {
            element.classList.add('truncated-text-460');
        }
    });
}

function applyTruncationToTestName() {
    document.querySelectorAll('.test-name-text').forEach(element => {
        if (element.clientWidth > 670) {
            element.classList.add('truncated-text-670');
        }
    });
}

function navigateToElementByTestId(testId, isSuite) {
    testId = testId.replaceAll(',', '.');
    if (!isSuite) {
        toggleCollapsedElementsWithNavigationWidget(testId + '-test-data');
    }
    document.getElementById(testId).scrollIntoView({
        behavior: 'instant',
        block: 'start',
    });
}

function navigateToElementById(elementIdWithIndex, errorElement, isBlockingError) {
    let errorParentElement = isBlockingError ? errorElement.parentElement.parentElement : errorElement.parentElement.parentElement.parentElement.parentElement.parentElement;

    let toggleButtonElement = errorParentElement.querySelectorAll(".action-button-text")[0];
    let iconRightElement = toggleButtonElement.parentElement.querySelector('.display-toggle-icon-right');

    if (iconRightElement) {
        toggleActionsView(toggleButtonElement);
    }

    let elementById;
    let split = elementIdWithIndex.split(':');
    let elementId = split[0];
    let elementIndex = split[1];

    let elementsById = Array.from(document.querySelectorAll(`.error.${CSS.escape(elementId)}`));
    if (elementsById.length > 1) {
        elementById = elementsById[elementIndex];
    } else {
        elementById = elementsById[0];
    }

    elementById.scrollIntoView({
        behavior: 'instant',
        block: 'start',
    });

    let statusLine = elementById;
    flashElement(statusLine);
    setTimeout(() => {
        flashElement(statusLine);
    }, 500);
}

function flashElement(element) {
    element.classList.add('flash');
    setTimeout(() => {
        element.classList.remove('flash');
    }, 250);
    setTimeout(() => {
        element.classList.remove('flash');
    }, 250);
}

function navigateToNextAndPrevElementById(button, isNext) {
    let id = button.parentElement.childNodes[1].childNodes[3].title;
    let suiteId = button.parentElement.parentElement.childNodes[1].textContent.replace("Playlist:", "").trim() + '-suite-data';
    const containers = Array.from(document.querySelectorAll('.general-layout'))
        .filter(value => value.parentElement.parentElement.id === suiteId);
    const currentIndex = containers.findIndex(div => div.id === id);
    if (currentIndex === -1) {
        console.log('Element not found');
        return;
    }

    const prevElement = containers[(currentIndex - 1 + containers.length) % containers.length];
    const nextElement = containers[(currentIndex + 1) % containers.length];

    if (isNext) {
        navigateToElementByTestId(nextElement.id, false);
    } else {
        navigateToElementByTestId(prevElement.id, false);
    }
}

function navigateToNextAndPrevSuiteById(button, isNext) {
    let id = button.parentElement.childNodes[3].title;
    const containers = Array.from(document.querySelectorAll('.playlist-info-header'));
    const currentIndex = containers.findIndex(div => div.id === id);
    if (currentIndex === -1) {
        console.log('Element not found');
        return;
    }
    const prevElement = containers[(currentIndex - 1 + containers.length) % containers.length];
    const nextElement = containers[(currentIndex + 1) % containers.length];

    if (isNext) {
        let suiteElementToggle = nextElement.getElementsByClassName('display-toggle-icon-right')[0];
        if (suiteElementToggle) {
            suiteElementToggle.click();
        }
        navigateToElementByTestId(nextElement.id, true);
    } else {
        let suiteElementToggle = prevElement.getElementsByClassName('display-toggle-icon-right')[0];
        if (suiteElementToggle) {
            suiteElementToggle.click();
        }
        navigateToElementByTestId(prevElement.id, true);
    }
}

function buildChartDuration(canvas) {
    let dataElements = Array.from(canvas.parentElement.parentElement.parentElement.parentElement.querySelectorAll('.header'));
    let actionLabels = [];
    let peaks = dataElements.map((el, index) => {
        let actionLabelElement = el.querySelector('.action-name');
        actionLabels.push(actionLabelElement ? actionLabelElement.textContent.trim() : null);
        let dataArray = el.classList[1].split("-");
        return Number(dataArray[dataArray.length - 1] + index / '1e6');
    });

    let peaksWithElements = dataElements.map((el, index) => {
        let dataArray = el.classList[1].split("-");
        return {"value": Number(dataArray[dataArray.length - 1] + index / '1e6'), "element": el};
    });

    const ctx = canvas.getContext('2d');

    const data = peaks;
    const maxValue = Math.max(...data);
    const canvasWidth = canvas.width;
    const canvasHeight = canvas.height;
    const padding = 10;
    const stepSize = (canvasWidth - 2 * padding) / (data.length - 1);

    const points = [];
    const actions = [];

    const tooltip = document.createElement('div');
    tooltip.style.position = 'absolute';
    tooltip.style.backgroundColor = '#fff';
    tooltip.style.border = '1px solid #ccc';
    tooltip.style.padding = '5px';
    tooltip.style.borderRadius = '3px';
    tooltip.style.boxShadow = '0 0 5px rgba(0,0,0,0.3)';
    tooltip.style.pointerEvents = 'none';
    tooltip.style.display = 'none';
    tooltip.style.fontFamily = 'Arial, sans-serif';
    tooltip.style.fontSize = '9px';
    tooltip.style.fontWeight = '600';
    document.body.appendChild(tooltip);

    function drawChart() {
        ctx.clearRect(0, 0, canvasWidth, canvasHeight);

        ctx.strokeStyle = '#e0e0e0';
        ctx.lineWidth = 1;
        const numLines = 5;

        let maxPeak = Math.round(Math.max(...peaks)/10000);
        let roundedResult = Math.round(maxPeak / 5);

        const lineValues = [maxPeak, '', roundedResult*3, '','', 0];

        for (let i = 0; i <= numLines; i++) {
            let  modifDisplay = 0;
            if (lineValues[i] !== '') {
                modifDisplay = 4;
            }

            const y = padding + i * ((canvasHeight - 2 * padding) / numLines);
            ctx.beginPath();
            ctx.moveTo(padding, y);
            ctx.lineTo(canvasWidth - padding - modifDisplay, y);
            ctx.stroke();
            ctx.closePath();

            ctx.font = '8px Arial';
            ctx.fillStyle = '#989898';
            ctx.textAlign = 'right';
            ctx.fillText(lineValues[i], canvasWidth - padding + 5, y + 2);
        }

        ctx.beginPath();
        ctx.moveTo(padding, canvasHeight - padding - (data[0] / maxValue * (canvasHeight - 2 * padding)));

        let totalValue = 0;
        let interval = Math.ceil(data.length / 5);

        data.forEach((value, index) => {
            const x = padding + index * stepSize;
            const y = canvasHeight - padding - (value / maxValue * (canvasHeight - 2 * padding));
            label = actionLabels[index];
            points.push({x, y, value, label});
            ctx.lineTo(x, y);

            if (index % interval === 0) {
                let displayValue = Math.round(totalValue)/10000;
                if (displayValue > 1) {
                    displayValue = Math.round(displayValue);
                }
                ctx.fillText(displayValue, x, canvasHeight);
            }
            totalValue += value;
        });

        ctx.strokeStyle = '#3498DB';
        ctx.lineWidth = 2;
        ctx.stroke();
        ctx.closePath();
    }

    function drawHoverDots(mouseX, mouseY) {
        let foundPoint = false;
        points.forEach((point, index) => {
            const distance = Math.sqrt((point.x - mouseX) ** 2 + (point.y - mouseY) ** 2);
            if (distance < 5) {
                canvas.style.cursor = 'pointer';
                foundPoint = true;

                tooltip.style.left = mouseX + canvas.getBoundingClientRect().left + window.scrollX + 10 + 'px';
                tooltip.style.top = mouseY + canvas.getBoundingClientRect().top + window.scrollY - 10 + 'px';
                tooltip.innerHTML = point.label + ' - ' + Math.round(point.value / 10) + ' ms';
                tooltip.style.display = 'block';
            }
        });
        if (!foundPoint) {
            canvas.style.cursor = 'default';
            tooltip.style.display = 'none';
        }
    }

    drawChart();

    function goToElement(targetDuration) {
        peaksWithElements.filter(el => el.value === targetDuration).forEach(el => {
            let toggleElement = el.element.parentElement.parentElement.parentElement.parentElement.querySelector('.display-toggle-icon-right');
            if (toggleElement) {
                toggleElement.click();
            }
            el.element.scrollIntoView({
                behavior: 'instant',
                block: 'start',
            })
        });
    }

    canvas.addEventListener('click', (event) => {
        const rect = canvas.getBoundingClientRect();
        const mouseX = event.clientX - rect.left;
        const mouseY = event.clientY - rect.top;

        let wentToElement = false;
        points.forEach(point => {
            const distance = Math.sqrt((point.x - mouseX) ** 2 + (point.y - mouseY) ** 2);
            if (distance < 5 && !wentToElement) {
                goToElement(point.value);
                wentToElement = true;
            }
        });
    });

    canvas.addEventListener('mousemove', (event) => {
        const rect = canvas.getBoundingClientRect();
        const mouseX = event.clientX - rect.left;
        const mouseY = event.clientY - rect.top;
        drawChart();
        drawHoverDots(mouseX, mouseY);
    });
}

function buildChartTypes(canvas) {
    const baseElement = canvas.parentElement.parentElement.parentElement.parentElement.parentElement;
    const data = [
        { label: "Navigation", value: baseElement.querySelectorAll('.atl-navigation').length, color: "#1BBC9B" },
        { label: "Callscript", value: baseElement.querySelectorAll('.atl-calls').length, color: "#3498DB" },
        { label: "User action", value: baseElement.querySelectorAll('.atl-user-actions').length, color: "#72B500" },
        { label: "Assertion", value: baseElement.querySelectorAll('.atl-assert').length, color: "#EE6AB9" },
        { label: "Technical", value: baseElement.querySelectorAll('.atl-technical').length, color: "#6E4AD3" },
        { label: "Others", value: baseElement.querySelectorAll('.atl-others').length, color: "#7D7D7D" }
    ];

    const ctx = canvas.getContext("2d");

    const chartHeight = 100;
    const rationValue = chartHeight / Math.max(...data.map(item => item.value));
    const barWidth = 15;
    const gap = 5;
    const startX = 10;
    const rightMargin = 140;
    const totalBarsWidth = data.length * (barWidth + gap) - gap;

    const gridCount = 5;
    const gridGap = chartHeight / gridCount;
    ctx.strokeStyle = "#ccc";
    ctx.lineWidth = 0.5;

    for (let i = 0; i <= gridCount; i++) {
        const y = canvas.height - (gridGap * i);
        ctx.beginPath();
        ctx.moveTo(startX, y);
        ctx.lineTo(rightMargin - 5, y);
        ctx.stroke();
    }

    function drawChart() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);

        data.forEach((item, index) => {
            const x = startX + (barWidth + gap) * index;
            const height = item.value * rationValue;
            const y = canvas.height - height;

            ctx.fillStyle = item.color;
            ctx.fillRect(x, y, barWidth, height);
        });

        ctx.font = "12px Arial";
        ctx.textAlign = "left";
        ctx.fillStyle = "#000";

        data.forEach((item, index) => {
            const y = 12 + index * 18;
            const x = startX + totalBarsWidth + rightMargin - 100;

            const squareSize = 10;
            ctx.fillStyle = item.color;
            ctx.fillRect(x - squareSize - 5, y - 4 - squareSize / 2, squareSize, squareSize);

            ctx.fillStyle = "#000";
            ctx.fillText(item.label, x, y);
        });
    }

    drawChart();

    canvas.onmousemove = (event) => {
        const rect = canvas.getBoundingClientRect();
        const mouseX = event.clientX - rect.left;
        const mouseY = event.clientY - rect.top;

        drawChart();

        data.forEach((item, index) => {
            const x = startX + (barWidth + gap) * index;
            const height = item.value * rationValue;
            const y = canvas.height - height;

            if (mouseX >= x && mouseX <= x + barWidth && mouseY >= y && mouseY <= canvas.height) {
                ctx.fillStyle = "#FFF";
                ctx.strokeStyle = "#888a89";
                ctx.lineWidth = 1;
                ctx.fillRect(mouseX, mouseY - 20, 20, 20);
                ctx.strokeRect(mouseX, mouseY - 20, 20, 20);
                ctx.fillStyle = "#000";
                ctx.font = "9px Arial";
                ctx.fillText(item.value, mouseX + 5, mouseY - 5);
            }
        });
    };
}

function applyChartsToTestInfos() {

    let chartsElementsDuration = Array.from(document.querySelectorAll('.charts-container-chart-element.chart-duration'));
    chartsElementsDuration.forEach(chart => buildChartDuration(chart));

    let chartsElementsTypes = Array.from(document.querySelectorAll('.charts-container-chart-element.chart-types'));
    chartsElementsTypes.forEach(chart => buildChartTypes(chart));
}

function applyHeightToIframes() {
    let iFrames = document.getElementsByTagName('iFrame');
    if (iFrames) {
        Array.from(iFrames).forEach(element => {
            if (element) {
                element.style.height = element.contentWindow.document.body.scrollHeight + 40 + 'px';
                let iframeDocument = element.contentDocument || element.contentWindow.document;
                let style = iframeDocument.createElement('style');
                style.textContent = "body { font-family: 'Arial', sans-serif; }";
                iframeDocument.head.appendChild(style);
            }
        });
    }
}

function unwrapFirstPlayList() {
    let elementNodeListOf = document.querySelectorAll('.display-toggle-icon-right');
    if (elementNodeListOf.length > 0) {
        elementNodeListOf.item(0).click();
    }
}

window.onload = function () {
    if (document) {
        unwrapFirstPlayList();
        applyTruncationToScriptNamesInAction();
        applyTruncationToTestName();
        applyTruncationToSuiteName();
        applyChartsToTestInfos();
        applyHeightToIframes();
    }
}