/*
 * Decompiled with CFR 0.152.
 */
package com.ats.driver;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import org.openqa.selenium.Proxy;

public class AtsProxy {
    public static final String AUTO = "auto";
    public static final String SYSTEM = "system";
    public static final String DIRECT = "direct";
    public static final String MANUAL = "manual";
    public static final String PAC = "pac";
    private String type;
    private String host;
    private int port;
    private String pacUrl;

    public AtsProxy() {
    }

    public AtsProxy(String type) {
        this.type = type;
    }

    public AtsProxy(String host, int port) {
        this(MANUAL, host, port);
    }

    public AtsProxy(String type, String host, int port) {
        this.type = type;
        this.host = host;
        this.port = port;
    }

    public AtsProxy(String type, String url) {
        this.type = type;
        this.pacUrl = url;
    }

    public String getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean enabled() {
        return this.type != null;
    }

    public org.openqa.selenium.Proxy getValue() {
        org.openqa.selenium.Proxy proxy = new org.openqa.selenium.Proxy();
        if (AUTO.equals(this.type)) {
            proxy.setProxyType(Proxy.ProxyType.AUTODETECT);
        } else if (PAC.equals(this.type)) {
            proxy.setProxyAutoconfigUrl(this.pacUrl);
        } else if (DIRECT.equals(this.type)) {
            proxy.setProxyType(Proxy.ProxyType.DIRECT);
        } else if (MANUAL.equals(this.type)) {
            String proxyAddress = this.host + ":" + this.port;
            proxy.setHttpProxy(proxyAddress).setSslProxy(proxyAddress);
        } else {
            proxy.setProxyType(Proxy.ProxyType.SYSTEM);
        }
        return proxy;
    }

    public Proxy getHttpProxy() {
        if (MANUAL.equals(this.type)) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.host, this.port));
        }
        return Proxy.NO_PROXY;
    }

    public URI getPacUri() {
        if (PAC.equals(this.type)) {
            try {
                return new URI(this.pacUrl);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }
}

