/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.desktop;

import com.ats.AtsSingleton;
import com.ats.data.Dimension;
import com.ats.data.Point;
import com.ats.data.Rectangle;
import com.ats.driver.AtsRemoteWebDriver;
import com.ats.element.AtsBaseElement;
import com.ats.element.FoundElement;
import com.ats.element.JsonUtils;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.ScriptStatus;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.RemoteDriverInfo;
import com.ats.executor.drivers.desktop.DesktopData;
import com.ats.executor.drivers.desktop.DesktopResponse;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.executor.drivers.engines.SystemDriverEngine;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.recorder.RecorderSummaryData;
import com.ats.recorder.TestSummary;
import com.ats.script.ScriptHeader;
import com.ats.tools.OperatingSystem;
import com.ats.tools.Utils;
import com.ats.tools.logger.ExecutionLogger;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.Gson;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SystemDriver
extends AtsRemoteWebDriver {
    private static final int TIME_OUT = 600;
    private static final String MS_EDGE_PATH = "MsEdgePath";
    private static final String ATS_CLIENT_ID = "Ats-Client-Id";
    private static final String ERROR_ATS_DESKTOP_RESPONSE = "ErrorAtsDesktopResponse";
    private List<FoundElement> elementMapLocation;
    private IDriverInfo systemDriverInfo;
    private SystemDriverEngine engine;
    private OkHttpClient client;
    private String driverVersion;
    private String osName;
    private String osVersion;
    private String osBuildVersion;
    private String countryCode;
    private String machineName;
    private String screenWidth;
    private String screenHeight;
    private String driveLetter;
    private String diskTotalSize;
    private String diskFreeSpace;
    private String cpuArchitecture;
    private String cpuCores;
    private String cpuName;
    private String cpuSocket;
    private String cpuMaxClock;
    private String dotNetVersion;
    private String userHome;
    private boolean interactive = true;
    private Map<String, String> capabilities = new HashMap<String, String>();
    private String logFile;
    private final ObjectMapper mapper = new ObjectMapper();
    private static final String USER_AGENT_NAME = "AtsDesktopDriver";

    public SystemDriver() {
    }

    public SystemDriver(ActionStatus status, ActionTestScript script) {
        if ("true".equals(System.getProperty("ats.dev"))) {
            this.setDevTimeout();
        } else {
            this.setNormalTimeout();
        }
        this.systemDriverInfo = AtsSingleton.getInstance().getSystemDriver(status, script);
        if (status.isPassed()) {
            JsonNode sessionNode = this.sendRequestCommand(HttpMethod.GET, ApiRoute.ATS_SESSION.getPath());
            if (!sessionNode.has("capabilities")) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                sessionNode = this.sendRequestCommand(HttpMethod.GET, ApiRoute.ATS_SESSION.getPath());
            }
            if (sessionNode.has("capabilities")) {
                Iterator fields = sessionNode.get("capabilities").fields();
                while (fields.hasNext()) {
                    Map.Entry cap = (Map.Entry)fields.next();
                    if ("BuildNumber".equals(cap.getKey())) {
                        this.osBuildVersion = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("Name".equals(cap.getKey())) {
                        this.osName = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("Version".equals(cap.getKey())) {
                        this.osVersion = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("DriverVersion".equals(cap.getKey())) {
                        this.driverVersion = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("CountryCode".equals(cap.getKey())) {
                        this.countryCode = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("MachineName".equals(cap.getKey())) {
                        this.machineName = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("ScreenWidth".equals(cap.getKey())) {
                        this.screenWidth = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("ScreenHeight".equals(cap.getKey())) {
                        this.screenHeight = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("DriveLetter".equals(cap.getKey())) {
                        this.driveLetter = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("DiskTotalSize".equals(cap.getKey())) {
                        this.diskTotalSize = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("DiskFreeSpace".equals(cap.getKey())) {
                        this.diskFreeSpace = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("CpuSocket".equals(cap.getKey())) {
                        this.cpuSocket = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("CpuName".equals(cap.getKey())) {
                        this.cpuName = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("CpuArchitecture".equals(cap.getKey())) {
                        this.cpuArchitecture = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("CpuMaxClockSpeed".equals(cap.getKey())) {
                        this.cpuMaxClock = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("CpuCores".equals(cap.getKey())) {
                        this.cpuCores = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("DotNetVersion".equals(cap.getKey())) {
                        this.dotNetVersion = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("UserHome".equals(cap.getKey())) {
                        this.userHome = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    if ("Interactive".equals(cap.getKey())) {
                        this.interactive = !"false".equalsIgnoreCase(((JsonNode)cap.getValue()).asText());
                        continue;
                    }
                    if ("LogFile".equals(cap.getKey())) {
                        this.logFile = ((JsonNode)cap.getValue()).asText();
                        continue;
                    }
                    this.capabilities.put((String)cap.getKey(), ((JsonNode)cap.getValue()).asText());
                }
            } else if (sessionNode.has("error")) {
                status.setError(-19, sessionNode);
            } else {
                status.setError(-19, "unable to get system driver capabilities\ncheck SystemDriver is launched, DotNET and OS version ...");
            }
        } else {
            status.setError(-19, "unable to connect to system driver\ncheck SystemDriver is launched, DotNET and OS version ...");
        }
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public String getOsType() {
        return OperatingSystem.getType(this.osName);
    }

    public byte[] getIcon() {
        return OperatingSystem.getIcon(this.getOsType());
    }

    public boolean isEnabled() {
        return this.engine != null;
    }

    public boolean isLinux() {
        return OperatingSystem.isLinux(this.getOsName());
    }

    public String getMsEdgePath() {
        return this.capabilities.get(MS_EDGE_PATH);
    }

    private void setTimeout(int to) {
        this.client = new OkHttpClient.Builder().cache(null).connectTimeout((long)to, TimeUnit.SECONDS).writeTimeout((long)to, TimeUnit.SECONDS).readTimeout((long)to, TimeUnit.SECONDS).build();
    }

    public void setNormalTimeout() {
        this.setTimeout(600);
    }

    public void setExtendedTimeout() {
        this.setTimeout(1200);
    }

    private void setDevTimeout() {
        this.setTimeout(600000);
    }

    private void setDownloadTimeout() {
        this.setTimeout(36000);
    }

    public Double getScreenWidth() {
        try {
            return Double.parseDouble(this.screenWidth);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public Double getScreenHeight() {
        try {
            return Double.parseDouble(this.screenHeight);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public TestBound getScreenBound() {
        return new TestBound(0.0, 0.0, this.getScreenWidth(), this.getScreenHeight());
    }

    public void setEngine(SystemDriverEngine engine) {
        this.engine = engine;
        engine.setDriver(this);
    }

    public SystemDriverEngine getEngine() {
        return this.engine;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String getUserHome() {
        return this.userHome;
    }

    public String getOsFullName() {
        return this.getOsName() + " (" + this.getOsVersion() + ")";
    }

    public String getOsBuildVersion() {
        return this.osBuildVersion;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public String getScreenResolution() {
        return this.screenWidth + " x " + this.screenHeight;
    }

    public String getDriveLetter() {
        return this.driveLetter;
    }

    public String getDiskTotalSize() {
        return this.diskTotalSize;
    }

    public String getDiskFreeSpace() {
        return this.diskFreeSpace;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public String getCpuCores() {
        return this.cpuCores;
    }

    public String getCpuName() {
        return this.cpuName;
    }

    public String getCpuSocket() {
        return this.cpuSocket;
    }

    public String getCpuMaxClock() {
        return this.cpuMaxClock;
    }

    public String getDotNetVersion() {
        return this.dotNetVersion;
    }

    public StringBuilder getDriverHostAndPort() {
        return this.systemDriverInfo.getDriverHostAndPort();
    }

    public StringBuilder getLocalhostAndPort() {
        return new StringBuilder("http://localhost:").append(this.systemDriverInfo.getDriverServerUri().getPort());
    }

    public RemoteDriverInfo getRemoteDriver(ActionStatus status, String driverName, String appPath) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("ats", true);
        valueNode.put("remoteDriver", driverName);
        valueNode.put("operatingSystem", OperatingSystem.getOS());
        valueNode.put("applicationPath", appPath);
        JsonNode remoteDriver = this.sendRequestCommand(HttpMethod.POST, JsonUtils.createPostData(valueNode), ApiRoute.ATS_SESSION.getPath());
        if (remoteDriver.has("sessionId")) {
            String driverId = remoteDriver.get("sessionId").asText();
            JsonNode capabilities = remoteDriver.get("capabilities");
            if (capabilities.has("driverUrl")) {
                return new RemoteDriverInfo(driverId, this.systemDriverInfo.getDriverServerUri().getHost(), capabilities);
            }
        } else if (remoteDriver.has("error")) {
            status.setError(-17, remoteDriver);
        }
        return null;
    }

    public String getDriverHost() {
        return this.systemDriverInfo.getDriverServerUri().getHost();
    }

    public int getDriverPort() {
        return this.systemDriverInfo.getDriverServerUri().getPort();
    }

    public void closeDriver() {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.DRIVER_CLOSE.getPath());
    }

    public void closeWindows(long processId, int handle) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("processId", processId);
        valueNode.put("handle", handle);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.DRIVER_CLOSE_WINDOWS.getPath());
    }

    public void clearText() {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("id", null);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.KEY_CLEAR.getPath());
    }

    public void clearText(String elemId) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("id", elemId);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.KEY_CLEAR.getPath());
    }

    public void sendKeys(String data, String elemId) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("id", elemId);
        valueNode.put("data", data);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.KEY_ENTER.getPath());
    }

    public void keyDown(int codePoint) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("codePoint", codePoint);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.KEY_DOWN.getPath());
    }

    public void keyUp(int codePoint) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("codePoint", codePoint);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.KEY_RELEASE.getPath());
    }

    public void mouseMove(double x, double y) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("x", (int)x);
        valueNode.put("y", (int)y);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.MOUSE_MOVE.getPath());
    }

    public void mouseClick() {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.MOUSE_CLICK.getPath());
    }

    public void mouseClick(int key) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("key", key);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.MOUSE_CLICK.getPath());
    }

    public void mouseRightClick() {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.MOUSE_RIGHT_CLICK.getPath());
    }

    public void mouseMiddleClick() {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.MOUSE_MIDDLE_CLICK.getPath());
    }

    public void doubleClick() {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.MOUSE_DOUBLE_CLICK.getPath());
    }

    public void mouseDown() {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.MOUSE_DOWN.getPath());
    }

    public void drag() {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.MOUSE_DRAG.getPath());
    }

    public void mouseRelease() {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.MOUSE_RELEASE.getPath());
    }

    public void mouseWheel(int delta) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("delta", delta);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.MOUSE_WHEEL.getPath());
    }

    public List<FoundElement> getWebElementsListByHandle(TestBound channelDimension, int handle, long pid) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", handle);
        valueNode.put("pid", pid);
        List<FoundElement> list = this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_LOAD_TREE.getPath()).getFoundElements(channelDimension);
        ArrayList<FoundElement> flatList = new ArrayList<FoundElement>();
        for (FoundElement item : list) {
            item.flatten(flatList);
        }
        flatList.sort(Comparator.comparingDouble(FoundElement::getArea));
        return flatList;
    }

    public void defineRoot(TestBound channelDimension, String id) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("id", id);
        this.setElementMapLocation(this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_ROOT.getPath()).getFoundElements(channelDimension));
    }

    public void refreshElementMapLocation(Channel channel) {
        new Thread(new LoadMapElement(channel, this)).start();
    }

    public void refreshElementMap(Channel channel) {
        this.setElementMapLocation(this.getWebElementsListByHandle(channel.getDimension(), channel.getHandle(this), channel.getProcessId()));
    }

    public void setElementMapLocation(List<FoundElement> list) {
        FoundElement parent = new FoundElement();
        list.forEach(e -> this.recalculateSize(parent, (FoundElement)e));
        this.elementMapLocation = list;
    }

    private void recalculateSize(FoundElement parent, FoundElement elem) {
        if (elem.getScreenX() == 1.0 && elem.getScreenY() == 1.0 && elem.getWidth() == 1.0 && elem.getHeight() == 1.0) {
            elem.updateSize(parent.getScreenX(), parent.getScreenY(), parent.getWidth(), parent.getHeight(), parent.getX(), parent.getY());
        }
        if (elem.isVisible() && elem.getWidth() > 0.0 && elem.getHeight() > 0.0) {
            parent.updateSize(elem.getBoundX() + elem.getWidth(), elem.getBoundY() + elem.getHeight());
        }
        if (elem.getChildren() != null) {
            elem.getChildren().parallelStream().forEach(e -> this.recalculateSize(elem, (FoundElement)e));
        }
    }

    public FoundElement getElementFromPoint(Double x, Double y) {
        Optional<FoundElement> fe;
        double xPos = x;
        double yPos = y - 10.0;
        if (this.elementMapLocation != null && !this.elementMapLocation.isEmpty() && (fe = this.elementMapLocation.stream().filter(e -> e.isActive() && e.getRectangle().contains(xPos, yPos)).findFirst()).isPresent()) {
            return this.getHoverChild(fe.get(), xPos, yPos);
        }
        return null;
    }

    private FoundElement getHoverChild(FoundElement elem, double xPos, double yPos) {
        Optional child;
        if (elem.getChildren() != null && !elem.getChildren().isEmpty() && (child = ((Stream)((Stream)elem.getChildren().stream().parallel()).filter(e -> e.isActive() && e.getRectangle().contains(xPos, yPos)).parallel()).sorted((a, b) -> -1).findFirst()).isPresent()) {
            return this.getHoverChild((FoundElement)child.get(), xPos, yPos);
        }
        return elem;
    }

    public FoundElement getElementFromRect(Double x, Double y, Double w, Double h) {
        FoundElement hoverElement = null;
        if (this.elementMapLocation != null) {
            for (FoundElement testElement : this.elementMapLocation) {
                if (testElement == null || !testElement.isVisible()) continue;
                if (hoverElement == null) {
                    hoverElement = testElement;
                    continue;
                }
                Rectangle rect = testElement.getRectangle();
                if (!rect.contains(x, y) || rect.getWidth() > w || rect.getHeight() > h || hoverElement.getWidth() <= testElement.getWidth() && hoverElement.getHeight() <= testElement.getHeight()) continue;
                hoverElement = testElement;
            }
        }
        return hoverElement;
    }

    public FoundElement getRootElement(Channel channel) {
        return this.getRootElement(channel.getHandle(this));
    }

    public FoundElement getRootElement(int handle) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", handle);
        return new FoundElement(this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.WINDOW_HANDLE.getPath()).getWindow());
    }

    public List<FoundElement> getContextMenu(Channel channel) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("pid", channel.getProcessId());
        return this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_CONTEXT_MENU.getPath()).getFoundElements(channel.getDimension());
    }

    public List<DesktopData> getShapes(TestBound channelDimension, String duration, String device, int[] rect) throws Exception {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("duration", duration);
        valueNode.put("device", device);
        valueNode.put("crop", Arrays.stream(rect).mapToObj(String::valueOf).collect(Collectors.joining(",")));
        DesktopResponse resp = this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.DRIVER_SHAPES.getPath());
        if (resp.getErrorCode() != 0) {
            throw new Exception(resp.getErrorMessage());
        }
        return resp.getData();
    }

    public DesktopResponse startApplication(boolean attach, ArrayList<String> args) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("attach", attach);
        valueNode.put("args", String.join((CharSequence)"\n", args));
        return this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.DRIVER_APPLICATION.getPath());
    }

    public List<DesktopWindow> getWindowsByPid(long pid) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("pid", pid);
        DesktopResponse response = this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.WINDOW_LIST.getPath());
        return response.getWindows();
    }

    public void updateWindowHandle(Channel channel) {
        int handle = channel.getHandle(this);
        if (handle > 0) {
            HashMap<String, Object> valueNode = new HashMap<String, Object>();
            valueNode.put("handle", handle);
            this.getEngine().setWindow(this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.WINDOW_HANDLE.getPath()).getWindow());
        }
    }

    public void closeDialogBoxes(long pid) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("pid", pid);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.WINDOW_CLOSE_MODAL_WINDOWS.getPath());
    }

    public DesktopWindow getWindowByHandle(int handle) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", handle);
        return this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.WINDOW_HANDLE.getPath()).getWindow();
    }

    public DesktopWindow getWindowByTitle(String title, String name) {
        return DesktopWindow.createWindow(this.getWindowByTiltleOrName(title, name));
    }

    public DesktopWindow openExplorerWindow() {
        return DesktopWindow.createWindow(this.sendRequestCommand(HttpMethod.GET, ApiRoute.ATS_EXPLORER.getPath()));
    }

    public void setChannelToFront(int handle, long pid) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", handle);
        valueNode.put("pid", pid);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.WINDOW_TO_FRONT.getPath());
    }

    public void setWindowToFront(long pid, int handle) {
        this.setChannelToFront(handle, pid);
    }

    public void rootKeys(int handle, String keys) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", handle);
        valueNode.put("keys", keys);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.WINDOW_KEYS.getPath());
    }

    public void moveWindow(Channel channel, Point point) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", channel.getHandle(this));
        valueNode.put("value1", point.x);
        valueNode.put("value2", point.y);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.WINDOW_MOVE.getPath());
    }

    public void resizeWindow(Channel channel, Dimension size) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", channel.getHandle(this));
        valueNode.put("value1", size.width);
        valueNode.put("value2", size.height);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.WINDOW_RESIZE.getPath());
    }

    public void switchTo(Channel channel, int index) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", channel.getHandle(this, index));
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.WINDOW_SWITCH.getPath());
    }

    public DesktopResponse switchTo(long processId, int index, int handle) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", handle);
        valueNode.put("index", index);
        valueNode.put("pid", processId);
        return this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.WINDOW_SWITCH.getPath());
    }

    public void closeWindow(Channel channel) {
        this.closeWindow(channel.getHandle(this));
    }

    public void closeWindow(int handle) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", handle);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.WINDOW_CLOSE.getPath());
    }

    public void closeExplorerWindow(int handle) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", handle);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.WINDOW_CLOSE_WINDOW.getPath());
    }

    public void windowState(ActionStatus status, Channel channel, String state) {
        this.windowState(status, channel.getHandle(this), state);
    }

    public void windowState(ActionStatus status, int handle, String state) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", handle);
        valueNode.put("state", state);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.WINDOW_STATE.getPath());
    }

    public void ostracon(ActionStatus status, int handle) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", handle);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.DRIVER_OSTRACON.getPath());
    }

    public void gotoUrl(ActionStatus status, int handle, String url) {
        status.setData(url);
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("handle", handle);
        valueNode.put("url", url);
        DesktopResponse resp = this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.WINDOW_URL.getPath());
        if (resp.getErrorCode() < 0) {
            status.setError(resp.getErrorCode(), resp.getErrorMessage());
        } else {
            status.setPassed(true);
        }
    }

    public FoundElement getTestElementParent(String elementId, Channel channel) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("id", elementId);
        return this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_PARENTS.getPath()).getParentsElement(channel.getDimension());
    }

    public CalculatedProperty[] getElementAttributes(String elementId) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("id", elementId);
        return this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_ATTRIBUTES.getPath()).getElementAttributes();
    }

    public String getTextData(String id) {
        return "";
    }

    public List<DesktopData> executeScript(ActionStatus status, String script, FoundElement element) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("id", element.getId());
        valueNode.put("script", script);
        return this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_SCRIPT.getPath()).getData();
    }

    public void elementFocus(FoundElement element) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("id", element.getId());
        this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_FOCUS.getPath());
    }

    public List<FoundElement> findElements(Channel channel, TestElement testElement, String tag, String[] attributes, Predicate<AtsBaseElement> predicate) {
        DesktopResponse resp;
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("tag", tag);
        valueNode.put("attributes", attributes);
        if (testElement.getParent() != null) {
            valueNode.put("id", testElement.getParent().getWebElementId());
            resp = this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_CHILDS.getPath());
        } else {
            valueNode.put("handle", channel.getHandle(this));
            resp = this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_FIND.getPath());
        }
        return resp.getFoundElements(predicate, channel.getDimension());
    }

    public List<FoundElement> getListItems(TestBound dimension, String comboId) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("id", comboId);
        return this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_LIST_ITEMS.getPath()).getFoundElements(dimension);
    }

    public List<FoundElement> getChildren(TestBound dimension, String comboId, String tag) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("id", comboId);
        valueNode.put("tag", tag);
        return this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_CHILDS.getPath()).getFoundElements(dimension);
    }

    public void selectItem(ActionStatus status, String elementId, String type, String value, boolean regexp) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("id", elementId);
        valueNode.put("type", type);
        valueNode.put("value", value);
        valueNode.put("regexp", regexp);
        DesktopResponse resp = this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_SELECT.getPath());
        if (resp.getErrorMessage() != null) {
            status.setError(-1, resp.getErrorMessage());
        }
    }

    public String getElementAttribute(String elementId, String attribute) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("id", elementId);
        valueNode.put("attribute", attribute);
        return this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_ATTRIBUTES.getPath()).getFirstAttribute();
    }

    public List<FoundElement> getDialogBox(TestBound dimension, Long pId) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("pId", pId);
        return this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.ELEMENT_DIALOG_BOX.getPath()).getFoundElements(dimension);
    }

    private IDriverInfo getDriverInfo() {
        if (AtsSingleton.getInstance().getCurrentChannel() != null && AtsSingleton.getInstance().getCurrentChannel().getDriverEngine() != null) {
            return AtsSingleton.getInstance().getCurrentChannel().getDriverEngine().getDriverInfo();
        }
        return null;
    }

    public void saveSummary(ScriptStatus status, TestSummary summary) {
        RecorderSummaryData recorder = summary.getRecordSummary(status, this.getDriverInfo());
        this.sendRequestCommand(HttpMethod.POST, JsonUtils.createPostData(recorder), ApiRoute.RECORDER_SUMMARY.getPath());
    }

    public void stopVisualRecord() {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        if (this.getDriverInfo() != null) {
            valueNode.put("driverInfo", Objects.requireNonNull(this.getDriverInfo()).toJson());
        }
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.RECORDER_STOP.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getScreenshotByte(Double x, Double y, Double w, Double h) {
        byte[] img = null;
        String url = this.systemDriverInfo.getDriverHostAndPort().append("/screencapture/").append(x.intValue()).append(",").append(y.intValue()).append(",").append(w.intValue()).append(",").append(h.intValue()).toString();
        Request request = new Request.Builder().url(url).addHeader("User-Agent", USER_AGENT_NAME).get().build();
        Response response = null;
        try {
            response = this.client.newCall(request).execute();
            if (response.body() != null) {
                img = response.body().bytes();
            }
            response.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (response != null) {
                    if (response.body() != null) {
                        response.body().close();
                    }
                    response.close();
                }
            }
            catch (Exception exception) {}
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getMobileScreenshotByte(String url) {
        byte[] img = null;
        Request request = new Request.Builder().url(url).addHeader("User-Agent", USER_AGENT_NAME).addHeader("Content-Type", "text/plain").post(RequestBody.Companion.create("hires", Utils.TEXT_MEDIA)).build();
        Response response = null;
        try {
            response = this.client.newCall(request).execute();
            if (response.body() != null) {
                img = response.body().bytes();
            }
            response.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (response != null) {
                    if (response.body() != null) {
                        response.body().close();
                    }
                    response.close();
                }
            }
            catch (Exception exception) {}
        }
        return img;
    }

    public void createMobileRecord(boolean stop, String actionType, int scriptLine, String scriptName, long timeline, String channelName, TestBound subDimension, String screenshotPath, boolean sync) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("actionType", actionType);
        valueNode.put("line", scriptLine);
        valueNode.put("script", scriptName);
        valueNode.put("timeLine", timeline);
        valueNode.put("channelName", channelName);
        valueNode.put("channelDimensionX", subDimension.getX().intValue());
        valueNode.put("channelDimensionY", subDimension.getY().intValue());
        valueNode.put("channelDimensionWidth", subDimension.getWidth().intValue());
        valueNode.put("channelDimensionHeight", subDimension.getHeight().intValue());
        valueNode.put("url", screenshotPath);
        valueNode.put("sync", sync);
        valueNode.put("stop", stop);
        if (this.getDriverInfo() != null) {
            valueNode.put("driverInfo", Objects.requireNonNull(this.getDriverInfo()).toJson().get("driverInfo"));
        }
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.RECORDER_CREATE_MOBILE.getPath());
    }

    public void createVisualAction(Channel channel, boolean stop, String actionType, int scriptLine, String scriptName, long timeline, boolean sync) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("actionType", actionType);
        valueNode.put("line", scriptLine);
        valueNode.put("script", scriptName);
        valueNode.put("timeLine", timeline);
        valueNode.put("channelName", channel.getName());
        valueNode.put("channelDimensionX", channel.getDimension().getX().intValue());
        valueNode.put("channelDimensionY", channel.getDimension().getY().intValue());
        valueNode.put("channelDimensionWidth", channel.getDimension().getWidth().intValue());
        valueNode.put("channelDimensionHeight", channel.getDimension().getHeight().intValue());
        valueNode.put("sync", sync);
        valueNode.put("stop", stop);
        if (this.getDriverInfo() != null) {
            valueNode.put("driverInfo", Objects.requireNonNull(this.getDriverInfo()).toJson().get("driverInfo"));
        }
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.RECORDER_CREATE.getPath());
    }

    public void updateMobileScreenshot(TestBound bound, boolean isRef, String url) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        double[] screenRect = new double[]{0.0, 0.0, bound.getWidth().intValue(), bound.getHeight().intValue()};
        valueNode.put("screenRect", screenRect);
        valueNode.put("isRef", isRef);
        valueNode.put("url", url);
        if (this.getDriverInfo() != null) {
            valueNode.put("driverInfo", Objects.requireNonNull(this.getDriverInfo()).toJson().get("driverInfo"));
        }
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.RECORDER_IMAGE_MOBILE.getPath());
    }

    public DesktopResponse startVisualRecord(ScriptHeader header, int quality, long started) {
        Map<String, Object> valueNode = header.getJsonData(quality, started);
        if (this.getDriverInfo() != null) {
            valueNode.put("driverInfo", Objects.requireNonNull(this.getDriverInfo()).toJson().get("driverInfo"));
        }
        if (AtsSingleton.getInstance().getCurrentChannel() != null && AtsSingleton.getInstance().getCurrentChannel().getDriverEngine() != null) {
            return this.sendDesktopRequest(valueNode, HttpMethod.POST, ApiRoute.RECORDER_START.getPath());
        }
        return null;
    }

    public void startVisualRecord(Channel channel, ScriptHeader header, int quality, long started) {
        Map<String, Object> valueNode = header.getJsonData(quality, started);
        if (this.getDriverInfo() != null) {
            valueNode.put("driverInfo", Objects.requireNonNull(this.getDriverInfo()).toJson().get("driverInfo"));
        }
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.RECORDER_START.getPath());
    }

    public void updateVisualImage(TestBound dimension, boolean isRef) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        double[] screenRect = new double[]{dimension.getX().intValue(), dimension.getY().intValue(), dimension.getWidth().intValue(), dimension.getHeight().intValue()};
        valueNode.put("screenRect", screenRect);
        valueNode.put("isRef", isRef);
        if (this.getDriverInfo() != null) {
            valueNode.put("driverInfo", Objects.requireNonNull(this.getDriverInfo()).toJson().get("driverInfo"));
        }
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.RECORDER_IMAGE.getPath());
    }

    public void updateVisualValue(String value) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("v", value);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.RECORDER_VALUE.getPath());
    }

    public void updateVisualData(String value, String data) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("v1", value);
        valueNode.put("v2", data);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.RECORDER_DATA.getPath());
    }

    public void updateVisualStatus(int error, long duration) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("error", error);
        valueNode.put("duration", duration);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.RECORDER_STATUS.getPath());
    }

    public void updateVisualElement(TestElement element) {
        if (this.isEnabled()) {
            HashMap<String, Object> valueNode = new HashMap<String, Object>();
            Double[] elementBound = element.getBound();
            TestElement e = element;
            String selector = e.getSelector();
            while (selector.isEmpty() && e.getParent() != null) {
                e = e.getParent();
                selector = e.getSelector();
            }
            if (selector.length() > 100) {
                selector = selector.substring(0, 100);
            }
            Arrays.setAll(elementBound, j -> elementBound[j] == null ? 0.0 : (double)elementBound[j].intValue());
            valueNode.put("searchDuration", element.getTotalSearchDuration());
            valueNode.put("elementBound", elementBound);
            valueNode.put("numElements", element.getElementsCount());
            valueNode.put("selector", selector);
            valueNode.put("tag", element.getSearchedTag());
            this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.RECORDER_ELEMENT.getPath());
        }
    }

    public void updateVisualPosition(String type, MouseDirectionData hdir, MouseDirectionData vdir) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        this.updateVisualValue(type);
        String hdirName = "";
        int hdirValue = 0;
        String vdirName = "";
        int vdirValue = 0;
        if (hdir != null) {
            hdirName = hdir.getName();
            hdirValue = hdir.getIntValue();
        }
        if (vdir != null) {
            vdirName = vdir.getName();
            vdirValue = vdir.getIntValue();
        }
        valueNode.put("hpos", hdirName);
        valueNode.put("hposValue", hdirValue);
        valueNode.put("vpos", vdirName);
        valueNode.put("vposValue", vdirValue);
        this.sendRequestCommandVoid(valueNode, HttpMethod.POST, ApiRoute.RECORDER_POSITION.getPath());
    }

    public JsonNode getWindowHandle(String sessionId) {
        return this.sendRequestCommand(HttpMethod.GET, ApiRoute.ATS_SESSION.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveVisualReportFile(Path path, ExecutionLogger logger) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        if (this.getDriverInfo() != null) {
            valueNode.put("driverInfo", Objects.requireNonNull(this.getDriverInfo()).toJson().get("driverInfo"));
        }
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = JsonUtils.createPostData(mapper, valueNode);
        StringBuilder urlBuilder = this.systemDriverInfo.getDriverHostAndPort();
        for (String data : ApiRoute.RECORDER_DOWNLOAD.getPath()) {
            urlBuilder.append("/").append(data);
        }
        Request.Builder request = new Request.Builder().url(urlBuilder.toString()).addHeader("User-Agent", USER_AGENT_NAME);
        request.post(RequestBody.Companion.create(node.toString(), Utils.JSON_MEDIA));
        this.setDownloadTimeout();
        Response response = null;
        try {
            response = this.client.newCall(request.build()).execute();
            if (response.code() == 200 && response.body() != null) {
                int inByte;
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path.toFile()));
                BufferedInputStream bis = new BufferedInputStream(response.body().byteStream());
                int totalByte = 0;
                while ((inByte = bis.read()) != -1) {
                    bos.write(inByte);
                    totalByte += inByte;
                }
                bis.close();
                bos.close();
                totalByte = (int)((double)totalByte * 8.0E-6);
                logger.sendInfo("save ATSV file", path.toString() + " (" + totalByte + " Ko)");
            } else {
                logger.sendError("unable to save ATSV file", response.message());
            }
            response.close();
        }
        catch (IOException e) {
            logger.sendError("error saving ATSV file", e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    if (response.body() != null) {
                        response.body().close();
                    }
                    response.close();
                }
            }
            catch (Exception exception) {}
        }
        this.setNormalTimeout();
    }

    public String getSource() {
        return new Gson().toJson(this.elementMapLocation);
    }

    public JsonNode getUserFolder(String profile, String browserName) {
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("userProfile", profile);
        valueNode.put("browserName", browserName);
        return this.sendRequestCommand(HttpMethod.POST, JsonUtils.createPostData(mapper, valueNode), ApiRoute.ATS_PROFILE.getPath());
    }

    public JsonNode getWindowByTiltleOrName(String title, String name) {
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put("title", title);
        valueNode.put("name", name);
        return this.sendRequestCommand(HttpMethod.POST, JsonUtils.createPostData(mapper, valueNode), ApiRoute.ATS_WINDOW.getPath());
    }

    private JsonNode sendRequestCommand(HttpMethod method, String ... urlData) {
        return this.sendRequestCommand(method, (ObjectNode)null, urlData);
    }

    private DesktopResponse sendDesktopRequest(Map<String, Object> valueNode, HttpMethod method, String ... urlData) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode postData = JsonUtils.createPostData(mapper, valueNode);
        JsonNode result = this.sendRequestCommand(method, postData, urlData);
        return new DesktopResponse(result);
    }

    private void sendRequestCommandVoid(Map<String, Object> valueNode, HttpMethod method, String ... urlData) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode postData = JsonUtils.createPostData(mapper, valueNode);
        this.sendRequestCommand(method, postData, urlData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode sendRequestCommand(HttpMethod method, ObjectNode node, String ... urlData) {
        ObjectNode o;
        ObjectNode result;
        StringBuilder urlBuilder = this.systemDriverInfo.getDriverHostAndPort();
        for (String data : urlData) {
            urlBuilder.append("/").append(data);
        }
        Request.Builder request = new Request.Builder().url(urlBuilder.toString()).addHeader("User-Agent", USER_AGENT_NAME).addHeader(ATS_CLIENT_ID, this.systemDriverInfo.getUuid());
        if (method == HttpMethod.POST) {
            String jsonContent;
            if (node == null) {
                ObjectNode nullNode = this.mapper.createObjectNode();
                nullNode.putNull("value");
                jsonContent = nullNode.toString();
            } else {
                jsonContent = node.toString();
            }
            request.post(RequestBody.Companion.create(jsonContent, Utils.JSON_MEDIA));
        } else if (method == HttpMethod.GET) {
            request.get();
        } else if (method == HttpMethod.DELETE) {
            request.delete(null);
        }
        Response response = null;
        try {
            response = this.client.newCall(request.build()).execute();
            if (response.body() != null) {
                JsonNode responseNode = (JsonNode)this.mapper.readValue(response.body().byteStream(), JsonNode.class);
                response.close();
                if (responseNode.has("value")) {
                    String errorValue;
                    JsonNode valueNode = responseNode.get("value");
                    result = valueNode.isObject() && valueNode.has("error") ? ((errorValue = valueNode.get("error").asText()).equals(ERROR_ATS_DESKTOP_RESPONSE) ? valueNode.get("datas") : responseNode.get("value")) : responseNode.get("value");
                } else {
                    o = this.mapper.createObjectNode();
                    ObjectNode error = o.putObject("error");
                    error.put("message", responseNode.toString());
                    result = o;
                }
            } else {
                ObjectNode o2 = this.mapper.createObjectNode();
                ObjectNode error = o2.putObject("error");
                error.put("message", "No response from driver");
                result = o2;
            }
        }
        catch (IOException e) {
            o = this.mapper.createObjectNode();
            ObjectNode error = o.putObject("error");
            error.put("message", e.getMessage());
            result = o;
        }
        finally {
            try {
                if (response != null) {
                    if (response.body() != null) {
                        response.body().close();
                    }
                    response.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static enum HttpMethod {
        GET("GET"),
        POST("POST"),
        DELETE("DELETE");

        private final String type;

        private HttpMethod(String value) {
            this.type = value;
        }

        public String toString() {
            return this.type;
        }
    }

    public static enum ApiRoute {
        DRIVER_CAPABILITIES(new String[]{"session", "SESSION_ID", "ats", "driver", "capabilities"}),
        DRIVER_REMOTE_DRIVER(new String[]{"session", "SESSION_ID", "ats", "driver", "remoteDriver"}),
        DRIVER_APPLICATION(new String[]{"session", "SESSION_ID", "ats", "driver", "application"}),
        DRIVER_CLOSE_WINDOWS(new String[]{"session", "SESSION_ID", "ats", "driver", "closeWindows"}),
        DRIVER_CLOSE(new String[]{"session", "SESSION_ID", "ats", "driver", "close"}),
        DRIVER_OSTRACON(new String[]{"session", "SESSION_ID", "ats", "driver", "ostracon"}),
        DRIVER_SHAPES(new String[]{"session", "SESSION_ID", "ats", "driver", "shapes"}),
        MOUSE_MOVE(new String[]{"session", "SESSION_ID", "ats", "mouse", "move"}),
        MOUSE_CLICK(new String[]{"session", "SESSION_ID", "ats", "mouse", "click"}),
        MOUSE_RIGHT_CLICK(new String[]{"session", "SESSION_ID", "ats", "mouse", "rightClick"}),
        MOUSE_MIDDLE_CLICK(new String[]{"session", "SESSION_ID", "ats", "mouse", "middleClick"}),
        MOUSE_DOUBLE_CLICK(new String[]{"session", "SESSION_ID", "ats", "mouse", "doubleClick"}),
        MOUSE_DOWN(new String[]{"session", "SESSION_ID", "ats", "mouse", "down"}),
        MOUSE_RELEASE(new String[]{"session", "SESSION_ID", "ats", "mouse", "release"}),
        MOUSE_WHEEL(new String[]{"session", "SESSION_ID", "ats", "mouse", "wheel"}),
        MOUSE_DRAG(new String[]{"session", "SESSION_ID", "ats", "mouse", "drag"}),
        KEY_CLEAR(new String[]{"session", "SESSION_ID", "ats", "keyboard", "clear"}),
        KEY_ENTER(new String[]{"session", "SESSION_ID", "ats", "keyboard", "enter"}),
        KEY_DOWN(new String[]{"session", "SESSION_ID", "ats", "keyboard", "down"}),
        KEY_RELEASE(new String[]{"session", "SESSION_ID", "ats", "keyboard", "release"}),
        RECORDER_STOP(new String[]{"session", "SESSION_ID", "ats", "recorder", "stop"}),
        RECORDER_SCREENSHOT(new String[]{"session", "SESSION_ID", "ats", "recorder", "screenShot"}),
        RECORDER_START(new String[]{"session", "SESSION_ID", "ats", "recorder", "start"}),
        RECORDER_CREATE(new String[]{"session", "SESSION_ID", "ats", "recorder", "create"}),
        RECORDER_IMAGE(new String[]{"session", "SESSION_ID", "ats", "recorder", "image"}),
        RECORDER_VALUE(new String[]{"session", "SESSION_ID", "ats", "recorder", "value"}),
        RECORDER_DATA(new String[]{"session", "SESSION_ID", "ats", "recorder", "data"}),
        RECORDER_STATUS(new String[]{"session", "SESSION_ID", "ats", "recorder", "status"}),
        RECORDER_ELEMENT(new String[]{"session", "SESSION_ID", "ats", "recorder", "element"}),
        RECORDER_POSITION(new String[]{"session", "SESSION_ID", "ats", "recorder", "position"}),
        RECORDER_DOWNLOAD(new String[]{"session", "SESSION_ID", "ats", "recorder", "download"}),
        RECORDER_IMAGE_MOBILE(new String[]{"session", "SESSION_ID", "ats", "recorder", "imageMobile"}),
        RECORDER_CREATE_MOBILE(new String[]{"session", "SESSION_ID", "ats", "recorder", "createMobile"}),
        RECORDER_SCREENSHOT_MOBILE(new String[]{"session", "SESSION_ID", "ats", "recorder", "screenShotMobile"}),
        RECORDER_SUMMARY(new String[]{"session", "SESSION_ID", "ats", "recorder", "summary"}),
        WINDOW_TITLE(new String[]{"session", "SESSION_ID", "ats", "window", "title"}),
        WINDOW_HANDLE(new String[]{"session", "SESSION_ID", "ats", "window", "handle"}),
        WINDOW_LIST(new String[]{"session", "SESSION_ID", "ats", "window", "list"}),
        WINDOW_MOVE(new String[]{"session", "SESSION_ID", "ats", "window", "move"}),
        WINDOW_RESIZE(new String[]{"session", "SESSION_ID", "ats", "window", "resize"}),
        WINDOW_TO_FRONT(new String[]{"session", "SESSION_ID", "ats", "window", "toFront"}),
        WINDOW_SWITCH(new String[]{"session", "SESSION_ID", "ats", "window", "switch"}),
        WINDOW_CLOSE(new String[]{"session", "SESSION_ID", "ats", "window", "close"}),
        WINDOW_URL(new String[]{"session", "SESSION_ID", "ats", "window", "url"}),
        WINDOW_KEYS(new String[]{"session", "SESSION_ID", "ats", "window", "keys"}),
        WINDOW_STATE(new String[]{"session", "SESSION_ID", "ats", "window", "state"}),
        WINDOW_CLOSE_WINDOW(new String[]{"session", "SESSION_ID", "ats", "window", "closeWindow"}),
        WINDOW_CLOSE_MODAL_WINDOWS(new String[]{"session", "SESSION_ID", "ats", "window", "closeModalWindows"}),
        ELEMENT_CHILDS(new String[]{"session", "SESSION_ID", "ats", "element", "childs"}),
        ELEMENT_PARENTS(new String[]{"session", "SESSION_ID", "ats", "element", "parents"}),
        ELEMENT_FIND(new String[]{"session", "SESSION_ID", "ats", "element", "find"}),
        ELEMENT_ATTRIBUTES(new String[]{"session", "SESSION_ID", "ats", "element", "attributes"}),
        ELEMENT_SELECT(new String[]{"session", "SESSION_ID", "ats", "element", "select"}),
        ELEMENT_FROM_POINT(new String[]{"session", "SESSION_ID", "ats", "element", "fromPoint"}),
        ELEMENT_SCRIPT(new String[]{"session", "SESSION_ID", "ats", "element", "script"}),
        ELEMENT_ROOT(new String[]{"session", "SESSION_ID", "ats", "element", "root"}),
        ELEMENT_LOAD_TREE(new String[]{"session", "SESSION_ID", "ats", "element", "loadTree"}),
        ELEMENT_LIST_ITEMS(new String[]{"session", "SESSION_ID", "ats", "element", "listItems"}),
        ELEMENT_DIALOG_BOX(new String[]{"session", "SESSION_ID", "ats", "element", "dialogBox"}),
        ELEMENT_FOCUS(new String[]{"session", "SESSION_ID", "ats", "element", "focus"}),
        ELEMENT_CONTEXT_MENU(new String[]{"session", "SESSION_ID", "ats", "element", "contextMenu"}),
        ATS_STATUS(new String[]{"status"}),
        ATS_PROFILE(new String[]{"profile"}),
        ATS_EXPLORER(new String[]{"explorer"}),
        ATS_SESSION(new String[]{"session"}),
        ATS_WINDOW(new String[]{"window", "title"});

        private final String[] m_roadPath;

        private ApiRoute(String[] path) {
            this.m_roadPath = path;
        }

        public String[] getPath() {
            return this.getPath("1234567890");
        }

        public String[] getPath(String sessionId) {
            return (String[])Arrays.stream(this.m_roadPath).map(s -> "SESSION_ID".equals(s) ? sessionId : s).toArray(String[]::new);
        }
    }

    private static class LoadMapElement
    implements Runnable {
        final TestBound channelDimension;
        final int handle;
        final long pid;
        final SystemDriver driver;

        public LoadMapElement(Channel channel, SystemDriver driver) {
            this.channelDimension = channel.getDimension();
            this.handle = channel.getHandle(driver);
            this.pid = channel.getProcessId();
            this.driver = driver;
        }

        @Override
        public void run() {
            this.driver.setElementMapLocation(this.driver.getWebElementsListByHandle(this.channelDimension, this.handle, this.pid));
        }
    }
}

