/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines;

import com.ats.data.Dimension;
import com.ats.data.Point;
import com.ats.data.Rectangle;
import com.ats.driver.ApplicationProperties;
import com.ats.element.AtsBaseElement;
import com.ats.element.DesktopRootElement;
import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.SendKeyData;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.DesktopResponse;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.DriverEngine;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.executor.drivers.engines.desktop.DesktopAlert;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.script.actions.ActionApi;
import com.ats.tools.Utils;
import java.awt.MouseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public class SystemDriverEngine
extends DriverEngine
implements IDriverEngine {
    protected static final int DEFAULT_WAIT = 100;
    protected DesktopWindow window;
    private int windowIndex = -1;

    public SystemDriverEngine(Channel channel, boolean enableLearning) {
        super(channel, enableLearning);
    }

    public SystemDriverEngine(Channel channel, DesktopWindow window, boolean enableLearning) {
        super(channel, enableLearning);
        this.window = window;
    }

    public SystemDriverEngine(Channel channel, IDriverInfo driverInfo, SystemDriver systemDriver, ApplicationProperties props, int defaultWait, boolean enableLearning) {
        super(channel, driverInfo, systemDriver, props, 100, 0, enableLearning);
        systemDriver.setEngine(this);
    }

    public SystemDriverEngine(Channel channel, ActionStatus status, String application, IDriverInfo driverInfo, SystemDriver systemDriver, ApplicationProperties props, boolean enableLearning) {
        this(channel, driverInfo, systemDriver, props, 100, enableLearning);
        this.startApplication(status, application, props);
    }

    protected void startApplication(ActionStatus status, String application, ApplicationProperties props) {
        if (application.startsWith("desktop")) {
            this.channel.setApplicationData("desktop", this.getSystemDriver().getOsFullName(), "", this.getSystemDriver().getDriverVersion(), 0L, this.getSystemDriver().getIcon());
            FoundElement desktop = this.getSystemDriver().getRootElement(-1);
            this.channel.setDimensions(desktop.getTestScreenBound(), desktop.getTestScreenBound());
        } else {
            ArrayList<String> args;
            if (props.getUri() != null) {
                application = props.getUri();
                args = new ArrayList<String>(Arrays.asList(application));
                if (props.getOptions() != null) {
                    Arrays.asList(props.getOptions()).forEach(o -> args.add((String)o));
                }
            } else {
                args = new ArrayList<String>(Arrays.asList(application));
                this.channel.getArguments().forEach(c -> args.add(c.getCalculated()));
            }
            this.getSystemDriver().setExtendedTimeout();
            DesktopResponse resp = this.getSystemDriver().startApplication(this.channel.attachToExistingProcess(), args);
            if (resp.getErrorCode() == 0) {
                this.window = resp.getWindow();
                if (this.window != null) {
                    this.channel.setApplicationData("desktop", this.getSystemDriver().getOsName() + " (" + this.getSystemDriver().getOsVersion() + ")", this.window.getAppName(), this.window.getAppVersion() + " (" + this.window.getAppBuildVersion() + ")", this.getSystemDriver().getDriverVersion(), this.window.getPid(), this.window.getHandle(), this.window.getAppIcon());
                    this.windowIndex = 0;
                    this.applicationPath = this.window.getAppPath();
                    this.getSystemDriver().moveWindow(this.channel, this.channel.getDimension().getPoint());
                    this.getSystemDriver().resizeWindow(this.channel, this.channel.getDimension().getSize());
                    this.getSystemDriver().setNormalTimeout();
                } else {
                    status.setError(-19, "no window found for this application");
                }
            } else {
                status.setError(-19, resp.getErrorMessage());
            }
        }
    }

    public void setWindow(DesktopWindow window) {
        this.window = window;
    }

    @Override
    public void waitAfterAction(ActionStatus status) {
        this.actionWait();
    }

    @Override
    public SystemDriver getSystemDriver() {
        return (SystemDriver)this.driver;
    }

    @Override
    public void loadParents(FoundElement hoverElement) {
        hoverElement.setParent(this.getSystemDriver().getTestElementParent(hoverElement.getId(), this.channel));
    }

    @Override
    public String getAttribute(ActionStatus status, FoundElement element, String attributeName, int maxTry) {
        return this.getSystemDriver().getElementAttribute(element.getId(), attributeName);
    }

    @Override
    public CalculatedProperty[] getAttributes(FoundElement element, boolean reload) {
        return this.getAttributes(element.getId());
    }

    @Override
    public CalculatedProperty[] getHtmlAttributes(FoundElement element) {
        return this.getAttributes(element, true);
    }

    @Override
    public void setSysProperty(String propertyName, String propertyValue) {
    }

    public CalculatedProperty[] getAttributes(String elementId) {
        return this.getSystemDriver().getElementAttributes(elementId);
    }

    @Override
    public List<String[]> loadSelectOptions(TestElement element) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        List<FoundElement> options = this.findSelectOptions(this.channel.getDimension(), element);
        if (options != null && options.size() > 0) {
            options.stream().forEachOrdered(e -> result.add(e.getItemAttribute()));
        }
        return result;
    }

    @Override
    public List<FoundElement> findSelectOptions(TestBound dimension, TestElement element) {
        return this.getSystemDriver().getListItems(dimension, element.getFoundElement().getId());
    }

    @Override
    public void selectOptionsItem(ActionStatus status, TestElement element, CalculatedProperty selectProperty, boolean keepSelect) {
        this.getSystemDriver().selectItem(status, element.getFoundElement().getId(), selectProperty.getName(), selectProperty.getValue().getCalculated(), selectProperty.isRegexp());
    }

    @Override
    public String getTextData(FoundElement e) {
        return this.getSystemDriver().getTextData(e.getId());
    }

    @Override
    public FoundElement getElementFromPoint(Boolean syscomp, Double x, Double y) {
        return this.getSystemDriver().getElementFromPoint(x, y);
    }

    @Override
    public FoundElement getElementFromRect(Boolean syscomp, Double x, Double y, Double w, Double h) {
        return this.getSystemDriver().getElementFromRect(x, y, w, h);
    }

    @Override
    public List<FoundElement> findElements(boolean sysComp, TestElement testElement, String tag, String[] attributes, String[] attributesValues, Predicate<AtsBaseElement> predicate, WebElement startElement) {
        if (sysComp) {
            if ("SYSCOMP".equals(tag.toUpperCase())) {
                return new ArrayList<FoundElement>(List.of(new FoundElement(this.window)));
            }
            return this.getSystemDriver().findElements(this.channel, testElement, tag, attributesValues, predicate);
        }
        return this.getSystemDriver().findElements(this.channel, testElement, tag, attributesValues, predicate);
    }

    @Override
    public void updateDimensions() {
        DesktopWindow win = this.getSystemDriver().getWindowByHandle(this.channel.getHandle(this.getSystemDriver()));
        if (win != null && win.getWidth() > 0.0 && win.getHeight() > 0.0) {
            TestBound tb = new TestBound(win.getX(), win.getY(), win.getWidth(), win.getHeight());
            this.channel.setDimensions(tb, tb);
        }
    }

    @Override
    public void close() {
        if (this.getSystemDriver() != null) {
            this.getSystemDriver().closeWindows(this.channel.getProcessId(), this.channel.getHandle());
        }
    }

    @Override
    public boolean switchWindow(ActionStatus status, String type, String data, boolean regexp, int tries, boolean refresh) {
        int index = Utils.string2Int(data);
        DesktopResponse resp = this.getSystemDriver().switchTo(this.channel.getProcessId(), index, this.channel.getHandle());
        for (int maxTry = 1 + tries; resp.getErrorCode() == -14 && maxTry > 0; --maxTry) {
            this.channel.sleep(1000);
            resp = this.getSystemDriver().switchTo(this.channel.getProcessId(), index, this.channel.getHandle());
        }
        if (resp.getErrorCode() == -14) {
            status.setError(-14, "cannot switch to window index '" + index + "'");
        } else {
            this.channel.updateWinHandle(this.getSystemDriver(), index);
            this.windowIndex = index;
            status.setPassed(true);
        }
        return true;
    }

    @Override
    public void setWindowToFront() {
        this.channel.toFront();
        this.getSystemDriver().switchTo(this.channel.getProcessId(), this.windowIndex, this.channel.getHandle());
    }

    @Override
    public void closeWindow(ActionStatus status) {
        this.getSystemDriver().closeWindow(this.channel);
    }

    @Override
    public void middleClick(ActionStatus status, MouseDirection position, TestElement element) {
        this.getSystemDriver().mouseMiddleClick();
    }

    @Override
    public void doubleClick() {
        this.getSystemDriver().doubleClick();
    }

    @Override
    public void rightClick() {
        this.getSystemDriver().mouseRightClick();
    }

    @Override
    public void mouseMoveToElement(FoundElement element) {
        this.getSystemDriver().elementFocus(element);
    }

    @Override
    public void mouseMoveToElement(ActionStatus status, FoundElement foundElement, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
        Rectangle rect = foundElement.getRectangle();
        this.getSystemDriver().mouseMove(this.getOffsetX(rect, position) + (double)foundElement.getScreenX().intValue() - (double)foundElement.getCenterWidth(), this.getOffsetY(rect, position) + (double)foundElement.getScreenY().intValue() - (double)foundElement.getCenterHeight());
    }

    @Override
    public void mouseClick(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        this.getSystemDriver().mouseClick();
    }

    @Override
    public void drag(ActionStatus status, FoundElement element, MouseDirection md, int offsetX, int offsetY, boolean offset) {
        this.getSystemDriver().drag();
    }

    @Override
    public void drop(FoundElement element, MouseDirection md, boolean desktopDriver) {
        this.getSystemDriver().mouseRelease();
    }

    @Override
    public void swipe(ActionStatus status, FoundElement element, MouseDirection position, MouseDirection direction) {
        this.drag(status, element, position, 0, 0, false);
        this.getSystemDriver().mouseRelease();
    }

    @Override
    public void keyDown(Keys key) {
        this.getSystemDriver().keyDown(key.getCodePoint());
    }

    @Override
    public void keyUp(Keys key) {
        this.getSystemDriver().keyUp(key.getCodePoint());
    }

    @Override
    public void moveByOffset(int hDirection, int vDirection) {
        java.awt.Point pt = MouseInfo.getPointerInfo().getLocation();
        this.getSystemDriver().mouseMove(pt.x + hDirection, pt.y + vDirection);
    }

    @Override
    protected void setPosition(Point pt) {
        this.getSystemDriver().moveWindow(this.channel, pt);
    }

    @Override
    protected void setSize(Dimension size) {
        this.getSystemDriver().resizeWindow(this.channel, size);
    }

    @Override
    public void clearText(ActionStatus status, TestElement te, MouseDirection md) {
        FoundElement element = te.getFoundElement();
        this.mouseMoveToElement(status, element, md, false, 0, 0);
        this.mouseClick(status, element, null, 0, 0);
        this.getSystemDriver().clearText(te.getWebElementId());
    }

    @Override
    public void sendTextData(ActionStatus status, TestElement element, ArrayList<SendKeyData> textActionList, int waitChar, ActionTestScript topScript) {
        for (SendKeyData sequence : textActionList) {
            if (sequence.getDownKey() != null) {
                this.getSystemDriver().keyDown(sequence.getDownKey().getCodePoint());
                this.getSystemDriver().sendKeys(sequence.getSequenceDesktop(), element.getWebElementId());
                this.getSystemDriver().keyUp(sequence.getDownKey().getCodePoint());
                continue;
            }
            this.getSystemDriver().sendKeys(sequence.getSequenceDesktop(), element.getWebElementId());
        }
    }

    @Override
    public void refreshElementMapLocation() {
        this.getSystemDriver().refreshElementMapLocation(this.channel);
    }

    @Override
    public String getTitle() {
        return this.channel.getApplication();
    }

    @Override
    public Object executeScript(ActionStatus status, String script, Object ... params) {
        status.setPassed(true);
        return null;
    }

    @Override
    public void goToUrl(ActionStatus status, String url) {
        this.getSystemDriver().gotoUrl(status, this.window.getHandle(), url);
    }

    @Override
    public WebElement getRootElement(Channel cnl) {
        return new DesktopRootElement(this.getSystemDriver().getRootElement(cnl));
    }

    @Override
    public void scroll(FoundElement element) {
    }

    @Override
    public void scroll(int delta) {
        this.getSystemDriver().mouseWheel(delta);
    }

    @Override
    public void scroll(FoundElement element, int delta) {
        this.getSystemDriver().mouseWheel(delta);
    }

    @Override
    public DialogBox switchToAlert() {
        return new DesktopAlert(this, this.channel.getDimension());
    }

    @Override
    public boolean switchToDefaultContent(boolean dialog) {
        return true;
    }

    @Override
    public void switchToFrameId(String id) {
    }

    @Override
    public String getSource() {
        this.getSystemDriver().refreshElementMap(this.channel);
        return this.getSystemDriver().getSource();
    }

    @Override
    public String getSelectedText(TestElement e) {
        return "";
    }

    @Override
    public void api(ActionStatus status, ActionApi api) {
    }

    @Override
    public void buttonClick(ActionStatus status, String id) {
    }

    @Override
    public void tap(int count, FoundElement element) {
    }

    @Override
    public void press(int duration, ArrayList<String> paths, FoundElement element) {
    }

    @Override
    public void windowState(ActionStatus status, Channel channel, String state) {
        this.getSystemDriver().windowState(status, channel, state);
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, TestElement element) {
        return this.getSystemDriver().executeScript(status, script, element.getFoundElement());
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, boolean returnValue) {
        status.setPassed(true);
        return null;
    }

    public List<FoundElement> getDialogBox() {
        return this.getSystemDriver().getDialogBox(this.channel.getDimension(), null);
    }

    @Override
    public int getNumWindows() {
        return this.getSystemDriver().getWindowsByPid(this.channel.getProcessId()).size();
    }

    @Override
    public String getUrl() {
        return this.applicationPath;
    }

    @Override
    public Rectangle getBoundRect(TestElement testElement) {
        FoundElement elem = testElement.getFoundElement();
        if (elem != null) {
            return new Rectangle(elem.getX(), elem.getY(), elem.getWidth(), elem.getHeight());
        }
        return null;
    }

    @Override
    public String getCookies() {
        return "";
    }

    @Override
    public String getHeaders(ActionStatus status) {
        return "";
    }

    @Override
    public void quit() {
    }
}

